/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.graph;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import shaded.com.scylladb.cdc.driver3.common.collect.BiMap;
import shaded.com.scylladb.cdc.driver3.common.collect.HashBiMap;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableBiMap;
import shaded.com.scylladb.cdc.driver3.common.graph.AbstractUndirectedNetworkConnections;
import shaded.com.scylladb.cdc.driver3.common.graph.EdgesConnecting;
import shaded.com.scylladb.cdc.driver3.common.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class UndirectedNetworkConnections<N, E>
extends AbstractUndirectedNetworkConnections<N, E> {
    UndirectedNetworkConnections(Map<E, N> incidentEdgeMap) {
        super(incidentEdgeMap);
    }

    static <N, E> UndirectedNetworkConnections<N, E> of() {
        return new UndirectedNetworkConnections(HashBiMap.create(2));
    }

    static <N, E> UndirectedNetworkConnections<N, E> ofImmutable(Map<E, N> incidentEdges) {
        return new UndirectedNetworkConnections<N, E>(ImmutableBiMap.copyOf(incidentEdges));
    }

    @Override
    public Set<N> adjacentNodes() {
        return Collections.unmodifiableSet(((BiMap)this.incidentEdgeMap).values());
    }

    @Override
    public Set<E> edgesConnecting(N node) {
        return new EdgesConnecting(((BiMap)this.incidentEdgeMap).inverse(), node);
    }
}

