/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.common.hash;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import shaded.com.scylladb.cdc.driver3.common.annotations.Beta;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.hash.ElementTypesAreNonnullByDefault;
import shaded.com.scylladb.cdc.driver3.common.hash.HashCode;
import shaded.com.scylladb.cdc.driver3.common.hash.HashFunction;
import shaded.com.scylladb.cdc.driver3.common.hash.Hasher;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super(Preconditions.checkNotNull(out));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    public void write(int b) throws IOException {
        this.hasher.putByte((byte)b);
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

