/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.driver.core.BoundStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.CBUtil;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.Frame;
import shaded.com.scylladb.cdc.driver3.driver.core.MD5Digest;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolFeature;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.RegularStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.Requests;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.StatementWrapper;

public class BatchStatement
extends Statement {
    final Type batchType;
    private final List<Statement> statements = new ArrayList<Statement>();

    public BatchStatement() {
        this(Type.LOGGED);
    }

    public BatchStatement(Type batchType) {
        this.batchType = batchType;
    }

    IdAndValues getIdAndValues(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        IdAndValues idAndVals = new IdAndValues(this.statements.size());
        for (int i = 0; i < this.statements.size(); ++i) {
            Statement st;
            Statement statement = this.statements.get(i);
            if (statement instanceof StatementWrapper) {
                statement = ((StatementWrapper)statement).getWrappedStatement();
            }
            if (statement instanceof RegularStatement) {
                st = (RegularStatement)statement;
                ByteBuffer[] vals = ((RegularStatement)st).getValues(protocolVersion, codecRegistry);
                String query = ((RegularStatement)st).getQueryString(codecRegistry);
                idAndVals.ids.add(query);
                idAndVals.values[i] = vals == null ? Requests.EMPTY_BB_ARRAY : vals;
                continue;
            }
            assert (statement instanceof BoundStatement);
            st = (BoundStatement)statement;
            idAndVals.ids.add(((BoundStatement)st).statement.getPreparedId().boundValuesMetadata.id);
            idAndVals.values[i] = ((BoundStatement)st).wrapper.values;
        }
        return idAndVals;
    }

    public BatchStatement add(Statement statement) {
        if (statement instanceof StatementWrapper) {
            statement = ((StatementWrapper)statement).getWrappedStatement();
        }
        if (statement instanceof RegularStatement && ((RegularStatement)statement).usesNamedValues()) {
            throw new IllegalArgumentException("Batch statement cannot contain regular statements with named values (" + ((RegularStatement)statement).getQueryString() + ")");
        }
        if (statement instanceof BatchStatement) {
            for (Statement subStatements : ((BatchStatement)statement).statements) {
                this.add(subStatements);
            }
        } else {
            if (this.statements.size() >= 65535) {
                throw new IllegalStateException("Batch statement cannot contain more than 65535 statements.");
            }
            this.statements.add(statement);
        }
        return this;
    }

    public BatchStatement addAll(Iterable<? extends Statement> statements) {
        for (Statement statement : statements) {
            this.add(statement);
        }
        return this;
    }

    public Collection<Statement> getStatements() {
        return ImmutableList.copyOf(this.statements);
    }

    public BatchStatement clear() {
        this.statements.clear();
        return this;
    }

    public int size() {
        return this.statements.size();
    }

    @Override
    public int requestSizeInBytes(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int size = Frame.Header.lengthFor(protocolVersion) + 3;
        try {
            IdAndValues idAndVals = this.getIdAndValues(protocolVersion, codecRegistry);
            for (int i = 0; i < idAndVals.ids.size(); ++i) {
                Object q = idAndVals.ids.get(i);
                size += 1 + (q instanceof String ? CBUtil.sizeOfLongString((String)q) : CBUtil.sizeOfShortBytes(((MD5Digest)q).bytes));
                size += CBUtil.sizeOfValueList(idAndVals.values[i]);
            }
            switch (protocolVersion) {
                case V2: {
                    size += CBUtil.sizeOfConsistencyLevel(this.getConsistencyLevel());
                    break;
                }
                case V3: 
                case V4: 
                case V5: 
                case V6: {
                    size += CBUtil.sizeOfConsistencyLevel(this.getConsistencyLevel());
                    size += Requests.QueryFlag.serializedSize(protocolVersion);
                    size += CBUtil.sizeOfConsistencyLevel(this.getSerialConsistencyLevel());
                    if (ProtocolFeature.CLIENT_TIMESTAMPS.isSupportedBy(protocolVersion)) {
                        size += 8;
                    }
                    if (ProtocolFeature.CUSTOM_PAYLOADS.isSupportedBy(protocolVersion) && this.getOutgoingPayload() != null) {
                        size += CBUtil.sizeOfBytesMap(this.getOutgoingPayload());
                    }
                    break;
                }
                default: {
                    throw protocolVersion.unsupported();
                }
            }
        }
        catch (Exception e) {
            size = -1;
        }
        return size;
    }

    @Override
    public BatchStatement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        return (BatchStatement)super.setSerialConsistencyLevel(serialConsistency);
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        for (Statement statement : this.statements) {
            ByteBuffer rk;
            if (statement instanceof StatementWrapper) {
                statement = ((StatementWrapper)statement).getWrappedStatement();
            }
            if ((rk = statement.getRoutingKey(protocolVersion, codecRegistry)) == null) continue;
            return rk;
        }
        return null;
    }

    @Override
    public String getKeyspace() {
        for (Statement statement : this.statements) {
            String keyspace = statement.getKeyspace();
            if (keyspace == null) continue;
            return keyspace;
        }
        return null;
    }

    @Override
    public Boolean isIdempotent() {
        if (this.idempotent != null) {
            return this.idempotent;
        }
        return BatchStatement.isBatchIdempotent(this.statements);
    }

    void ensureAllSet() {
        for (Statement statement : this.statements) {
            if (!(statement instanceof BoundStatement)) continue;
            ((BoundStatement)statement).ensureAllSet();
        }
    }

    static class IdAndValues {
        public final List<Object> ids;
        public final ByteBuffer[][] values;

        IdAndValues(int nbstatements) {
            this.ids = new ArrayList<Object>(nbstatements);
            this.values = new ByteBuffer[nbstatements][];
        }
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

