/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import shaded.com.scylladb.cdc.driver3.buffer.ByteBuf;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableMap;
import shaded.com.scylladb.cdc.driver3.driver.core.BoundStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.DriverInternalError;
import shaded.com.scylladb.cdc.driver3.util.CharsetUtil;

abstract class CBUtil {
    private CBUtil() {
    }

    private static String readString(ByteBuf cb, int length) {
        try {
            String str = cb.toString(cb.readerIndex(), length, CharsetUtil.UTF_8);
            cb.readerIndex(cb.readerIndex() + length);
            return str;
        }
        catch (IllegalStateException e) {
            if (e.getCause() instanceof CharacterCodingException) {
                throw new DriverInternalError("Cannot decode string as UTF8");
            }
            throw e;
        }
    }

    static String readString(ByteBuf cb) {
        try {
            int length = cb.readUnsignedShort();
            return CBUtil.readString(cb, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverInternalError("Not enough bytes to read an UTF8 serialized string preceded by it's 2 bytes length");
        }
    }

    private static void writeString(String str, ByteBuf cb) {
        byte[] bytes = str.getBytes(CharsetUtil.UTF_8);
        cb.writeShort(bytes.length);
        cb.writeBytes(bytes);
    }

    static int sizeOfString(String str) {
        return 2 + CBUtil.encodedUTF8Length(str);
    }

    private static int encodedUTF8Length(String st) {
        int strlen = st.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = st.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    static void writeLongString(String str, ByteBuf cb) {
        byte[] bytes = str.getBytes(CharsetUtil.UTF_8);
        cb.writeInt(bytes.length);
        cb.writeBytes(bytes);
    }

    static int sizeOfLongString(String str) {
        return 4 + str.getBytes(CharsetUtil.UTF_8).length;
    }

    static byte[] readBytes(ByteBuf cb) {
        try {
            int length = cb.readUnsignedShort();
            byte[] bytes = new byte[length];
            cb.readBytes(bytes);
            return bytes;
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverInternalError("Not enough bytes to read a byte array preceded by it's 2 bytes length");
        }
    }

    static void writeShortBytes(byte[] bytes, ByteBuf cb) {
        cb.writeShort(bytes.length);
        cb.writeBytes(bytes);
    }

    static int sizeOfShortBytes(byte[] bytes) {
        return 2 + bytes.length;
    }

    private static int sizeOfBytes(ByteBuffer bytes) {
        return 4 + bytes.remaining();
    }

    static Map<String, ByteBuffer> readBytesMap(ByteBuf cb) {
        int length = cb.readUnsignedShort();
        ImmutableMap.Builder<String, ByteBuffer> builder = ImmutableMap.builder();
        for (int i = 0; i < length; ++i) {
            String key = CBUtil.readString(cb);
            ByteBuffer value = CBUtil.readValue(cb);
            if (value == null) {
                value = Statement.NULL_PAYLOAD_VALUE;
            }
            builder.put(key, value);
        }
        return builder.build();
    }

    static void writeBytesMap(Map<String, ByteBuffer> m4, ByteBuf cb) {
        cb.writeShort(m4.size());
        for (Map.Entry<String, ByteBuffer> entry : m4.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            ByteBuffer value = entry.getValue();
            if (value == Statement.NULL_PAYLOAD_VALUE) {
                value = null;
            }
            CBUtil.writeValue(value, cb);
        }
    }

    static int sizeOfBytesMap(Map<String, ByteBuffer> m4) {
        int size = 2;
        for (Map.Entry<String, ByteBuffer> entry : m4.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfBytes(entry.getValue());
        }
        return size;
    }

    static ConsistencyLevel readConsistencyLevel(ByteBuf cb) {
        return ConsistencyLevel.fromCode(cb.readUnsignedShort());
    }

    static void writeConsistencyLevel(ConsistencyLevel consistency, ByteBuf cb) {
        cb.writeShort(consistency.code);
    }

    static int sizeOfConsistencyLevel(ConsistencyLevel consistency) {
        return 2;
    }

    static <T extends Enum<T>> T readEnumValue(Class<T> enumType, ByteBuf cb) {
        String value = CBUtil.readString(cb);
        try {
            return Enum.valueOf(enumType, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DriverInternalError(String.format("Invalid value '%s' for %s", value, enumType.getSimpleName()));
        }
    }

    static <T extends Enum<T>> void writeEnumValue(T enumValue, ByteBuf cb) {
        CBUtil.writeString(enumValue.toString(), cb);
    }

    static <T extends Enum<T>> int sizeOfEnumValue(T enumValue) {
        return CBUtil.sizeOfString(enumValue.toString());
    }

    static UUID readUUID(ByteBuf cb) {
        long msb = cb.readLong();
        long lsb = cb.readLong();
        return new UUID(msb, lsb);
    }

    static List<String> readStringList(ByteBuf cb) {
        int length = cb.readUnsignedShort();
        ArrayList<String> l = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            l.add(CBUtil.readString(cb));
        }
        return l;
    }

    static void writeStringMap(Map<String, String> m4, ByteBuf cb) {
        cb.writeShort(m4.size());
        for (Map.Entry<String, String> entry : m4.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            CBUtil.writeString(entry.getValue(), cb);
        }
    }

    static int sizeOfStringMap(Map<String, String> m4) {
        int size = 2;
        for (Map.Entry<String, String> entry : m4.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfString(entry.getValue());
        }
        return size;
    }

    static Map<String, List<String>> readStringToStringListMap(ByteBuf cb) {
        int length = cb.readUnsignedShort();
        HashMap<String, List<String>> m4 = new HashMap<String, List<String>>(length);
        for (int i = 0; i < length; ++i) {
            String k = CBUtil.readString(cb).toUpperCase();
            List<String> v = CBUtil.readStringList(cb);
            m4.put(k, v);
        }
        return m4;
    }

    static ByteBuffer readValue(ByteBuf cb) {
        int length = cb.readInt();
        if (length < 0) {
            return null;
        }
        ByteBuf slice = cb.readSlice(length);
        return ByteBuffer.wrap(CBUtil.readRawBytes(slice));
    }

    static void writeValue(byte[] bytes, ByteBuf cb) {
        if (bytes == null) {
            cb.writeInt(-1);
            return;
        }
        cb.writeInt(bytes.length);
        cb.writeBytes(bytes);
    }

    static void writeValue(ByteBuffer bytes, ByteBuf cb) {
        if (bytes == null) {
            cb.writeInt(-1);
            return;
        }
        if (bytes == BoundStatement.UNSET) {
            cb.writeInt(-2);
            return;
        }
        cb.writeInt(bytes.remaining());
        cb.writeBytes(bytes.duplicate());
    }

    static int sizeOfValue(byte[] bytes) {
        return 4 + (bytes == null ? 0 : bytes.length);
    }

    static int sizeOfValue(ByteBuffer bytes) {
        return 4 + (bytes == null ? 0 : bytes.remaining());
    }

    static void writeValueList(ByteBuffer[] values, ByteBuf cb) {
        cb.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            ByteBuffer value = values[i];
            CBUtil.writeValue(value, cb);
        }
    }

    static int sizeOfValueList(ByteBuffer[] values) {
        int size = 2;
        for (int i = 0; i < values.length; ++i) {
            ByteBuffer value = values[i];
            size += CBUtil.sizeOfValue(value);
        }
        return size;
    }

    static void writeNamedValueList(Map<String, ByteBuffer> namedValues, ByteBuf cb) {
        cb.writeShort(namedValues.size());
        for (Map.Entry<String, ByteBuffer> entry : namedValues.entrySet()) {
            CBUtil.writeString(entry.getKey(), cb);
            CBUtil.writeValue(entry.getValue(), cb);
        }
    }

    static int sizeOfNamedValueList(Map<String, ByteBuffer> namedValues) {
        int size = 2;
        for (Map.Entry<String, ByteBuffer> entry : namedValues.entrySet()) {
            size += CBUtil.sizeOfString(entry.getKey());
            size += CBUtil.sizeOfValue(entry.getValue());
        }
        return size;
    }

    static InetSocketAddress readInet(ByteBuf cb) {
        int addrSize = cb.readByte() & 0xFF;
        byte[] address = new byte[addrSize];
        cb.readBytes(address);
        int port = cb.readInt();
        try {
            return new InetSocketAddress(InetAddress.getByAddress(address), port);
        }
        catch (UnknownHostException e) {
            throw new DriverInternalError(String.format("Invalid IP address (%d.%d.%d.%d) while deserializing inet address", address[0], address[1], address[2], address[3]));
        }
    }

    static InetAddress readInetWithoutPort(ByteBuf cb) {
        int addrSize = cb.readByte() & 0xFF;
        byte[] address = new byte[addrSize];
        cb.readBytes(address);
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            throw new DriverInternalError(String.format("Invalid IP address (%d.%d.%d.%d) while deserializing inet address", address[0], address[1], address[2], address[3]));
        }
    }

    private static byte[] readRawBytes(ByteBuf cb) {
        if (cb.hasArray() && cb.readableBytes() == cb.array().length) {
            cb.readerIndex(cb.writerIndex());
            return cb.array();
        }
        byte[] bytes = new byte[cb.readableBytes()];
        cb.readBytes(bytes);
        return bytes;
    }
}

