/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.AbstractFuture;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.FutureCallback;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.Uninterruptibles;
import shaded.com.scylladb.cdc.driver3.driver.core.DriverThrowables;
import shaded.com.scylladb.cdc.driver3.driver.core.GuavaCompatibility;
import shaded.com.scylladb.cdc.driver3.driver.core.ResultSet;
import shaded.com.scylladb.cdc.driver3.driver.core.ResultSetFuture;

class ChainedResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture {
    private volatile ResultSetFuture source;

    ChainedResultSetFuture() {
    }

    void setSource(ResultSetFuture source) {
        if (this.isCancelled()) {
            source.cancel(false);
        }
        this.source = source;
        GuavaCompatibility.INSTANCE.addCallback(source, new FutureCallback<ResultSet>(){

            @Override
            public void onSuccess(ResultSet result) {
                ChainedResultSetFuture.this.set(result);
            }

            @Override
            public void onFailure(Throwable t2) {
                ChainedResultSetFuture.this.setException(t2);
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.source == null || this.source.cancel(mayInterruptIfRunning)) && super.cancel(mayInterruptIfRunning);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }
}

