/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import shaded.com.scylladb.cdc.driver3.driver.core.AbstractTableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.DataTypeClassNameParser;
import shaded.com.scylladb.cdc.driver3.driver.core.Metadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Row;
import shaded.com.scylladb.cdc.driver3.driver.core.TableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.VersionNumber;
import shaded.com.scylladb.cdc.driver3.driver.core.utils.MoreObjects;

public class ColumnMetadata {
    static final String COLUMN_NAME = "column_name";
    static final String VALIDATOR = "validator";
    static final String TYPE = "type";
    static final String COMPONENT_INDEX = "component_index";
    static final String POSITION = "position";
    static final String KIND_V2 = "type";
    static final String KIND_V3 = "kind";
    static final String CLUSTERING_ORDER = "clustering_order";
    static final String DESC = "desc";
    static final String INDEX_TYPE = "index_type";
    static final String INDEX_OPTIONS = "index_options";
    static final String INDEX_NAME = "index_name";
    private final AbstractTableMetadata parent;
    private final String name;
    private final DataType type;
    private final boolean isStatic;

    private ColumnMetadata(AbstractTableMetadata parent, String name, DataType type, boolean isStatic) {
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.isStatic = isStatic;
    }

    static ColumnMetadata fromRaw(AbstractTableMetadata tm, Raw raw, DataType dataType) {
        return new ColumnMetadata(tm, raw.name, dataType, raw.kind == Raw.Kind.STATIC);
    }

    static ColumnMetadata forAlias(TableMetadata tm, String name, DataType type) {
        return new ColumnMetadata(tm, name, type, false);
    }

    public String getName() {
        return this.name;
    }

    public AbstractTableMetadata getParent() {
        return this.parent;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ColumnMetadata)) {
            return false;
        }
        ColumnMetadata that = (ColumnMetadata)other;
        return this.name.equals(that.name) && this.isStatic == that.isStatic && this.type.equals(that.type);
    }

    public int hashCode() {
        return MoreObjects.hashCode(this.name, this.isStatic, this.type);
    }

    public String toString() {
        String str = Metadata.quoteIfNecessary(this.name) + ' ' + this.type;
        return this.isStatic ? str + " static" : str;
    }

    static class Raw {
        public final String name;
        public Kind kind;
        public final int position;
        public final String dataType;
        public final boolean isReversed;
        public final Map<String, String> indexColumns = new HashMap<String, String>();

        Raw(String name, Kind kind, int position, String dataType, boolean isReversed) {
            this.name = name;
            this.kind = kind;
            this.position = position;
            this.dataType = dataType;
            this.isReversed = isReversed;
        }

        static Raw fromRow(Row row, VersionNumber version) {
            boolean reversed;
            String dataType;
            int position;
            Kind kind;
            String name = row.getString(ColumnMetadata.COLUMN_NAME);
            if (version.getMajor() < 2) {
                kind = Kind.REGULAR;
            } else if (version.getMajor() < 3) {
                kind = row.isNull("type") ? Kind.REGULAR : Kind.fromStringV2(row.getString("type"));
            } else {
                Kind kind2 = kind = row.isNull(ColumnMetadata.KIND_V3) ? Kind.REGULAR : Kind.fromStringV3(row.getString(ColumnMetadata.KIND_V3));
            }
            if (version.getMajor() >= 3) {
                position = row.getInt(ColumnMetadata.POSITION);
                if (position == -1) {
                    position = 0;
                }
            } else {
                int n = position = row.isNull(ColumnMetadata.COMPONENT_INDEX) ? 0 : row.getInt(ColumnMetadata.COMPONENT_INDEX);
            }
            if (version.getMajor() >= 3) {
                dataType = row.getString("type");
                String clusteringOrderStr = row.getString(ColumnMetadata.CLUSTERING_ORDER);
                reversed = clusteringOrderStr.equals(ColumnMetadata.DESC);
            } else {
                dataType = row.getString(ColumnMetadata.VALIDATOR);
                reversed = DataTypeClassNameParser.isReversed(dataType);
            }
            Raw c = new Raw(name, kind, position, dataType, reversed);
            if (version.getMajor() < 3) {
                for (String str : Arrays.asList(ColumnMetadata.INDEX_TYPE, ColumnMetadata.INDEX_NAME, ColumnMetadata.INDEX_OPTIONS)) {
                    if (!row.getColumnDefinitions().contains(str) || row.isNull(str)) continue;
                    c.indexColumns.put(str, row.getString(str));
                }
            }
            return c;
        }

        public static enum Kind {
            PARTITION_KEY("PARTITION_KEY", "PARTITION_KEY"),
            CLUSTERING_COLUMN("CLUSTERING_KEY", "CLUSTERING"),
            REGULAR("REGULAR", "REGULAR"),
            COMPACT_VALUE("COMPACT_VALUE", ""),
            STATIC("STATIC", "STATIC");

            final String v2;
            final String v3;

            private Kind(String v2, String v3) {
                this.v2 = v2;
                this.v3 = v3;
            }

            static Kind fromStringV2(String s2) {
                for (Kind kind : Kind.values()) {
                    if (!kind.v2.equalsIgnoreCase(s2)) continue;
                    return kind;
                }
                throw new IllegalArgumentException(s2);
            }

            static Kind fromStringV3(String s2) {
                for (Kind kind : Kind.values()) {
                    if (!kind.v3.equalsIgnoreCase(s2)) continue;
                    return kind;
                }
                throw new IllegalArgumentException(s2);
            }
        }
    }
}

