/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.scylladb.cdc.driver3.common.base.Splitter;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableMap;
import shaded.com.scylladb.cdc.driver3.driver.core.BoundStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnDefinitions;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.KeyspaceMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.LwtInfo;
import shaded.com.scylladb.cdc.driver3.driver.core.Metadata;
import shaded.com.scylladb.cdc.driver3.driver.core.PreparedId;
import shaded.com.scylladb.cdc.driver3.driver.core.PreparedStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.Responses;
import shaded.com.scylladb.cdc.driver3.driver.core.SimpleStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.TableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Token;
import shaded.com.scylladb.cdc.driver3.driver.core.UserType;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.RetryPolicy;

public class DefaultPreparedStatement
implements PreparedStatement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPreparedStatement.class);
    private static final String SCYLLA_CDC_LOG_SUFFIX = "_scylla_cdc_log";
    private static final Splitter SPACE_SPLITTER = Splitter.onPattern("\\s+");
    private static final Splitter COMMA_SPLITTER = Splitter.onPattern(",");
    final PreparedId preparedId;
    final String query;
    final String queryKeyspace;
    final Map<String, ByteBuffer> incomingPayload;
    final Cluster cluster;
    final boolean isLWT;
    final Token.Factory partitioner;
    volatile ByteBuffer routingKey;
    volatile ConsistencyLevel consistency;
    volatile ConsistencyLevel serialConsistency;
    volatile boolean traceQuery;
    volatile RetryPolicy retryPolicy;
    volatile ImmutableMap<String, ByteBuffer> outgoingPayload;
    volatile Boolean idempotent;
    volatile boolean skipMetadata;

    private DefaultPreparedStatement(PreparedId id, String query, String queryKeyspace, Map<String, ByteBuffer> incomingPayload, Cluster cluster, boolean isLWT, Token.Factory partitioner) {
        this.preparedId = id;
        this.query = query;
        this.queryKeyspace = queryKeyspace;
        this.incomingPayload = incomingPayload;
        this.cluster = cluster;
        this.isLWT = isLWT;
        this.partitioner = partitioner;
        this.skipMetadata = this.calculateSkipMetadata();
    }

    static DefaultPreparedStatement fromMessage(Responses.Result.Prepared msg, Cluster cluster, String query, String queryKeyspace, LwtInfo lwtInfo) {
        assert (msg.metadata.columns != null);
        ColumnDefinitions defs = msg.metadata.columns;
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        PreparedId.PreparedMetadata boundValuesMetadata = new PreparedId.PreparedMetadata(msg.statementId, defs);
        PreparedId.PreparedMetadata resultSetMetadata = new PreparedId.PreparedMetadata(msg.resultMetadataId, msg.resultMetadata.columns);
        int[] pkIndices = null;
        if (defs.size() > 0) {
            pkIndices = protocolVersion.compareTo(ProtocolVersion.V4) >= 0 ? msg.metadata.pkIndices : DefaultPreparedStatement.computePkIndices(cluster.getMetadata(), defs);
        }
        PreparedId preparedId = new PreparedId(boundValuesMetadata, resultSetMetadata, pkIndices, protocolVersion);
        Token.Factory partitoner = DefaultPreparedStatement.partitioner(defs, cluster);
        return new DefaultPreparedStatement(preparedId, query, queryKeyspace, msg.getCustomPayload(), cluster, lwtInfo != null && lwtInfo.isLwt(msg.metadata.flags), partitoner);
    }

    private static int[] computePkIndices(Metadata clusterMetadata, ColumnDefinitions boundColumns) {
        TableMetadata tm;
        List<ColumnMetadata> partitionKeyColumns = null;
        int[] pkIndexes = null;
        KeyspaceMetadata km4 = clusterMetadata.getKeyspace(Metadata.quote(boundColumns.getKeyspace(0)));
        if (km4 != null && (tm = km4.getTable(Metadata.quote(boundColumns.getTable(0)))) != null) {
            partitionKeyColumns = tm.getPartitionKey();
            pkIndexes = new int[partitionKeyColumns.size()];
            for (int i = 0; i < pkIndexes.length; ++i) {
                pkIndexes[i] = -1;
            }
        }
        for (int i = 0; i < boundColumns.size(); ++i) {
            DefaultPreparedStatement.maybeGetIndex(boundColumns.getName(i), i, partitionKeyColumns, pkIndexes);
        }
        return DefaultPreparedStatement.allSet(pkIndexes) ? pkIndexes : null;
    }

    private static void maybeGetIndex(String name, int j, List<ColumnMetadata> pkColumns, int[] pkIndexes) {
        if (pkColumns == null) {
            return;
        }
        for (int i = 0; i < pkColumns.size(); ++i) {
            if (!name.equals(pkColumns.get(i).getName())) continue;
            pkIndexes[i] = j;
            return;
        }
    }

    private static boolean allSet(int[] pkColumns) {
        if (pkColumns == null) {
            return false;
        }
        for (int i = 0; i < pkColumns.length; ++i) {
            if (pkColumns[i] >= 0) continue;
            return false;
        }
        return true;
    }

    private static Token.Factory partitioner(ColumnDefinitions defs, Cluster cluster) {
        if (defs == null || defs.size() == 0) {
            return null;
        }
        String keyspace = defs.getKeyspace(0);
        String table = defs.getTable(0);
        if (table.endsWith(SCYLLA_CDC_LOG_SUFFIX)) {
            String baseTableName = table.substring(0, table.length() - SCYLLA_CDC_LOG_SUFFIX.length());
            KeyspaceMetadata keyspaceMetadata = cluster.getMetadata().getKeyspace(keyspace);
            if (keyspaceMetadata == null) {
                return null;
            }
            TableMetadata tableMetadata = keyspaceMetadata.getTable(baseTableName);
            if (tableMetadata != null && tableMetadata.options.isScyllaCDC()) {
                return Token.CDCToken.FACTORY;
            }
        }
        return null;
    }

    private boolean calculateSkipMetadata() {
        if (this.cluster.manager.protocolVersion() == ProtocolVersion.V1 || this.preparedId.resultSetMetadata.variables == null) {
            return false;
        }
        if (this.preparedId.resultSetMetadata.id != null && this.preparedId.resultSetMetadata.id.bytes.length > 0) {
            return true;
        }
        switch (this.cluster.getConfiguration().getQueryOptions().getSkipCQL4MetadataResolveMethod()) {
            case ENABLED: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        if (DefaultPreparedStatement.isWildcardSelect(this.query)) {
            LOGGER.warn("Prepared statement {} is a wildcard select, which can cause prepared statement invalidation issues when executed on CQL4. These issues may lead to broken deserialization or data corruption. To mitigate this, the driver ensures that the server returns metadata with each query for such statements, though this negatively impacts performance. To avoid this, consider using a targeted select instead. Alternatively, you can enable the skip-cql4-metadata-resolve-method option in the execution profile by setting it to `always-on`, allowing the driver to ignore this issue and proceed regardless, risking broken deserialization or data corruption.", (Object)this.query);
            return false;
        }
        for (ColumnDefinitions.Definition columnDefinition : this.preparedId.resultSetMetadata.variables) {
            if (!DefaultPreparedStatement.containsUDT(columnDefinition.getType())) continue;
            LOGGER.warn("Prepared statement {} contains UDT in result, which can cause prepared statement invalidation issues when executed on CQL4. These issues may lead to broken deserialization or data corruption. To mitigate this, the driver ensures that the server returns metadata with each query for such statements, though this negatively impacts performance. To avoid this, consider using a targeted select instead. Alternatively, you can enable the skip-cql4-metadata-resolve-method option in the execution profile by setting it to `always-on`, allowing the driver to ignore this issue and proceed regardless, risking broken deserialization or data corruption.", (Object)this.query);
            return false;
        }
        return true;
    }

    public boolean isSkipMetadata() {
        return this.skipMetadata;
    }

    @Override
    public ColumnDefinitions getVariables() {
        return this.preparedId.boundValuesMetadata.variables;
    }

    @Override
    public BoundStatement bind(Object ... values) {
        BoundStatement bs = new BoundStatement(this);
        return bs.bind(values);
    }

    @Override
    public BoundStatement bind() {
        return new BoundStatement(this);
    }

    @Override
    public PreparedStatement setRoutingKey(ByteBuffer routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    @Override
    public PreparedStatement setRoutingKey(ByteBuffer ... routingKeyComponents) {
        this.routingKey = SimpleStatement.compose(routingKeyComponents);
        return this;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        return this.routingKey;
    }

    @Override
    public PreparedStatement setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    @Override
    public PreparedStatement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        if (!serialConsistency.isSerial()) {
            throw new IllegalArgumentException();
        }
        this.serialConsistency = serialConsistency;
        return this;
    }

    @Override
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public String getQueryKeyspace() {
        return this.queryKeyspace;
    }

    @Override
    public PreparedStatement enableTracing() {
        this.traceQuery = true;
        return this;
    }

    @Override
    public PreparedStatement disableTracing() {
        this.traceQuery = false;
        return this;
    }

    @Override
    public boolean isTracing() {
        return this.traceQuery;
    }

    @Override
    public PreparedStatement setRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    @Override
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Override
    public Token.Factory getPartitioner() {
        return this.partitioner;
    }

    @Override
    public PreparedId getPreparedId() {
        return this.preparedId;
    }

    @Override
    public Map<String, ByteBuffer> getIncomingPayload() {
        return this.incomingPayload;
    }

    @Override
    public Map<String, ByteBuffer> getOutgoingPayload() {
        return this.outgoingPayload;
    }

    @Override
    public PreparedStatement setOutgoingPayload(Map<String, ByteBuffer> payload) {
        this.outgoingPayload = payload == null ? null : ImmutableMap.copyOf(payload);
        return this;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.cluster.getConfiguration().getCodecRegistry();
    }

    @Override
    public PreparedStatement setIdempotent(Boolean idempotent) {
        this.idempotent = idempotent;
        return this;
    }

    @Override
    public Boolean isIdempotent() {
        return this.idempotent;
    }

    @Override
    public boolean isLWT() {
        return this.isLWT;
    }

    private static boolean containsUDT(DataType dataType) {
        if (dataType.isCollection()) {
            for (DataType elementType : dataType.getTypeArguments()) {
                if (!DefaultPreparedStatement.containsUDT(elementType)) continue;
                return true;
            }
            return false;
        }
        return dataType instanceof UserType;
    }

    private static boolean isWildcardSelect(String query) {
        List<String> chunks = SPACE_SPLITTER.splitToList(query.trim().toLowerCase());
        if (chunks.size() < 2) {
            return false;
        }
        if (!chunks.get(0).equals("select")) {
            return false;
        }
        for (String chunk : chunks) {
            if (chunk.equals("from")) {
                return false;
            }
            if (chunk.equals("*")) {
                return true;
            }
            for (String part : COMMA_SPLITTER.split(chunk)) {
                if (!part.equals("*")) continue;
                return true;
            }
        }
        return false;
    }
}

