/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.AbstractFuture;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.Uninterruptibles;
import shaded.com.scylladb.cdc.driver3.driver.core.AggregateMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.ArrayBackedResultSet;
import shaded.com.scylladb.cdc.driver3.driver.core.BoundStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.Connection;
import shaded.com.scylladb.cdc.driver3.driver.core.DriverThrowables;
import shaded.com.scylladb.cdc.driver3.driver.core.ExecutionInfo;
import shaded.com.scylladb.cdc.driver3.driver.core.FunctionMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.KeyspaceMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.MaterializedViewMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Message;
import shaded.com.scylladb.cdc.driver3.driver.core.Metadata;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.RequestHandler;
import shaded.com.scylladb.cdc.driver3.driver.core.Responses;
import shaded.com.scylladb.cdc.driver3.driver.core.ResultSet;
import shaded.com.scylladb.cdc.driver3.driver.core.ResultSetFuture;
import shaded.com.scylladb.cdc.driver3.driver.core.SchemaElement;
import shaded.com.scylladb.cdc.driver3.driver.core.SessionManager;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.TableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.UserType;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.ConnectionException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.DriverInternalError;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.OperationTimedOutException;

class DefaultResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture,
RequestHandler.Callback {
    private static final Logger logger = LoggerFactory.getLogger(ResultSetFuture.class);
    private final SessionManager session;
    private final ProtocolVersion protocolVersion;
    private final Message.Request request;
    private volatile RequestHandler handler;

    DefaultResultSetFuture(SessionManager session, ProtocolVersion protocolVersion, Message.Request request) {
        this.session = session;
        this.protocolVersion = protocolVersion;
        this.request = request;
    }

    @Override
    public void register(RequestHandler handler) {
        this.handler = handler;
    }

    @Override
    public Message.Request request() {
        return this.request;
    }

    @Override
    public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
        try {
            block1 : switch (response.type) {
                case RESULT: {
                    Responses.Result rm = (Responses.Result)response;
                    if (rm.getCustomPayload() != null && rm.getCustomPayload().containsKey("tablets-routing-v1") && statement instanceof BoundStatement) {
                        BoundStatement st = (BoundStatement)statement;
                        String keyspace = statement.getKeyspace();
                        String table = st.preparedStatement().getPreparedId().boundValuesMetadata.variables.getTable(0);
                        this.session.getCluster().getMetadata().getTabletMap().processTabletsRoutingV1Payload(keyspace, table, rm.getCustomPayload().get("tablets-routing-v1"));
                    }
                    switch (rm.kind) {
                        case SET_KEYSPACE: {
                            this.session.poolsState.setKeyspace(((Responses.Result.SetKeyspace)rm).keyspace);
                            this.set(ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement));
                            break block1;
                        }
                        case SCHEMA_CHANGE: {
                            ArrayBackedResultSet rs = ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement);
                            final Cluster.Manager cluster = this.session.cluster.manager;
                            if (!cluster.configuration.getQueryOptions().isMetadataEnabled()) {
                                cluster.waitForSchemaAgreementAndSignal(connection, this, rs);
                                break block1;
                            }
                            Responses.Result.SchemaChange scc = (Responses.Result.SchemaChange)rm;
                            switch (scc.change) {
                                case CREATED: 
                                case UPDATED: {
                                    cluster.refreshSchemaAndSignal(connection, this, rs, scc.targetType, scc.targetKeyspace, scc.targetName, scc.targetSignature);
                                    break block1;
                                }
                                case DROPPED: {
                                    if (scc.targetType == SchemaElement.KEYSPACE) {
                                        final KeyspaceMetadata removedKeyspace = cluster.metadata.removeKeyspace(scc.targetKeyspace);
                                        if (removedKeyspace != null) {
                                            cluster.executor.submit(new Runnable(){

                                                @Override
                                                public void run() {
                                                    cluster.metadata.triggerOnKeyspaceRemoved(removedKeyspace);
                                                }
                                            });
                                        }
                                    } else {
                                        KeyspaceMetadata keyspace = (KeyspaceMetadata)this.session.cluster.manager.metadata.keyspaces.get(scc.targetKeyspace);
                                        if (keyspace == null) {
                                            logger.warn("Received a DROPPED notification for {} {}.{}, but this keyspace is unknown in our metadata", new Object[]{scc.targetType, scc.targetKeyspace, scc.targetName});
                                        } else {
                                            switch (scc.targetType) {
                                                case TABLE: {
                                                    final TableMetadata removedTable = keyspace.removeTable(scc.targetName);
                                                    if (removedTable != null) {
                                                        cluster.executor.submit(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                cluster.metadata.triggerOnTableRemoved(removedTable);
                                                            }
                                                        });
                                                        break;
                                                    }
                                                    final MaterializedViewMetadata removedView = keyspace.removeMaterializedView(scc.targetName);
                                                    if (removedView == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnMaterializedViewRemoved(removedView);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case TYPE: {
                                                    final UserType removedType = keyspace.removeUserType(scc.targetName);
                                                    if (removedType == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnUserTypeRemoved(removedType);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case FUNCTION: {
                                                    final FunctionMetadata removedFunction = keyspace.removeFunction(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                                    if (removedFunction == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnFunctionRemoved(removedFunction);
                                                        }
                                                    });
                                                    break;
                                                }
                                                case AGGREGATE: {
                                                    final AggregateMetadata removedAggregate = keyspace.removeAggregate(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                                    if (removedAggregate == null) break;
                                                    cluster.executor.submit(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            cluster.metadata.triggerOnAggregateRemoved(removedAggregate);
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                    this.session.cluster.manager.waitForSchemaAgreementAndSignal(connection, this, rs);
                                    break block1;
                                }
                            }
                            logger.info("Ignoring unknown schema change result");
                            break block1;
                        }
                    }
                    this.set(ArrayBackedResultSet.fromMessage(rm, this.session, this.protocolVersion, info, statement));
                    break;
                }
                case ERROR: {
                    this.setException(((Responses.Error)response).asException(connection.endPoint));
                    break;
                }
                default: {
                    connection.defunct(new ConnectionException(connection.endPoint, String.format("Got unexpected %s response", new Object[]{response.type})));
                    this.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.endPoint})));
                }
            }
        }
        catch (Throwable e) {
            this.setException(new DriverInternalError("Unexpected error while processing response from " + connection.endPoint, e));
        }
    }

    @Override
    public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
        this.onSet(connection, response, null, null, latency);
    }

    @Override
    public void onException(Connection connection, Exception exception, long latency, int retryCount) {
        this.setException(exception);
    }

    @Override
    public boolean onTimeout(Connection connection, long latency, int retryCount) {
        this.setException(new OperationTimedOutException(connection.endPoint));
        return true;
    }

    void setResult(ResultSet rs) {
        this.set(rs);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!super.cancel(mayInterruptIfRunning)) {
            return false;
        }
        if (this.handler != null) {
            this.handler.cancel();
        }
        return true;
    }

    @Override
    public int retryCount() {
        return 0;
    }
}

