/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.Futures;
import shaded.com.scylladb.cdc.driver3.common.util.concurrent.ListenableFuture;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.PagingState;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.QueryTrace;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.utils.Bytes;

public class ExecutionInfo {
    private final int speculativeExecutions;
    private final int successfulExecutionIndex;
    private final List<Host> triedHosts;
    private final ConsistencyLevel achievedConsistency;
    private final QueryTrace trace;
    private final ByteBuffer pagingState;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;
    private final Statement statement;
    private volatile boolean schemaInAgreement;
    private final List<String> warnings;
    private final Map<String, ByteBuffer> incomingPayload;

    private ExecutionInfo(int speculativeExecutions, int successfulExecutionIndex, List<Host> triedHosts, ConsistencyLevel achievedConsistency, QueryTrace trace, ByteBuffer pagingState, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, Statement statement, boolean schemaAgreement, List<String> warnings, Map<String, ByteBuffer> incomingPayload) {
        this.speculativeExecutions = speculativeExecutions;
        this.successfulExecutionIndex = successfulExecutionIndex;
        this.triedHosts = triedHosts;
        this.achievedConsistency = achievedConsistency;
        this.trace = trace;
        this.pagingState = pagingState;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.statement = statement;
        this.schemaInAgreement = schemaAgreement;
        this.warnings = warnings;
        this.incomingPayload = incomingPayload;
    }

    ExecutionInfo(Host singleHost) {
        this(0, 0, ImmutableList.of(singleHost), null, null, null, null, null, null, true, Collections.emptyList(), null);
    }

    public ExecutionInfo(int speculativeExecutions, int successfulExecutionIndex, List<Host> triedHosts, ConsistencyLevel achievedConsistency, Map<String, ByteBuffer> customPayload) {
        this(speculativeExecutions, successfulExecutionIndex, triedHosts, achievedConsistency, null, null, null, null, null, false, null, customPayload);
    }

    ExecutionInfo with(QueryTrace newTrace, List<String> newWarnings, ByteBuffer newPagingState, Statement newStatement, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        return new ExecutionInfo(this.speculativeExecutions, this.successfulExecutionIndex, this.triedHosts, this.achievedConsistency, newTrace, newPagingState, protocolVersion, codecRegistry, newStatement, this.schemaInAgreement, newWarnings, this.incomingPayload);
    }

    public List<Host> getTriedHosts() {
        return this.triedHosts;
    }

    public Host getQueriedHost() {
        return this.triedHosts.get(this.triedHosts.size() - 1);
    }

    public int getSpeculativeExecutions() {
        return this.speculativeExecutions;
    }

    public int getSuccessfulExecutionIndex() {
        return this.successfulExecutionIndex;
    }

    public ConsistencyLevel getAchievedConsistencyLevel() {
        return this.achievedConsistency;
    }

    public QueryTrace getQueryTrace() {
        return this.trace;
    }

    public ListenableFuture<QueryTrace> getQueryTraceAsync() {
        return Futures.immediateFuture(this.trace);
    }

    public PagingState getPagingState() {
        if (this.pagingState == null) {
            return null;
        }
        return new PagingState(this.pagingState, this.statement, this.protocolVersion, this.codecRegistry);
    }

    public byte[] getPagingStateUnsafe() {
        if (this.pagingState == null) {
            return null;
        }
        return Bytes.getArray(this.pagingState);
    }

    public boolean isSchemaInAgreement() {
        return this.schemaInAgreement;
    }

    void setSchemaInAgreement(boolean schemaAgreement) {
        this.schemaInAgreement = schemaAgreement;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public Map<String, ByteBuffer> getIncomingPayload() {
        return this.incomingPayload;
    }

    public Statement getStatement() {
        return this.statement;
    }
}

