/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.AuthProvider;
import shaded.com.scylladb.cdc.driver3.driver.core.Authenticator;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.AuthenticationException;

public interface ExtendedAuthProvider
extends AuthProvider {
    public Authenticator newAuthenticator(EndPoint var1, String var2) throws AuthenticationException;

    @Override
    @Deprecated
    public Authenticator newAuthenticator(InetSocketAddress var1, String var2) throws AuthenticationException;

    public static class NoAuthProvider
    implements ExtendedAuthProvider {
        private static final String DSE_AUTHENTICATOR = "shaded.com.scylladb.cdc.driver3.bdp.cassandra.auth.DseAuthenticator";
        static final String NO_AUTHENTICATOR_MESSAGE = "Host %s requires authentication, but no authenticator found in Cluster configuration";

        @Override
        public Authenticator newAuthenticator(EndPoint endPoint, String authenticator) {
            if (authenticator.equals(DSE_AUTHENTICATOR)) {
                return new AuthProvider.TransitionalModePlainTextAuthenticator();
            }
            throw new AuthenticationException(endPoint, String.format(NO_AUTHENTICATOR_MESSAGE, endPoint));
        }

        @Override
        public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
            throw new AssertionError((Object)("The driver should never call this method on an object that implements " + this.getClass().getSimpleName()));
        }
    }
}

