/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.List;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandler;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandlerContext;
import shaded.com.scylladb.cdc.driver3.channel.ChannelPipeline;
import shaded.com.scylladb.cdc.driver3.driver.core.BytesToSegmentDecoder;
import shaded.com.scylladb.cdc.driver3.driver.core.Connection;
import shaded.com.scylladb.cdc.driver3.driver.core.Frame;
import shaded.com.scylladb.cdc.driver3.driver.core.Message;
import shaded.com.scylladb.cdc.driver3.driver.core.MessageToSegmentEncoder;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.SegmentCodec;
import shaded.com.scylladb.cdc.driver3.driver.core.SegmentToBytesEncoder;
import shaded.com.scylladb.cdc.driver3.driver.core.SegmentToFrameDecoder;
import shaded.com.scylladb.cdc.driver3.handler.codec.MessageToMessageDecoder;

public class FramingFormatHandler
extends MessageToMessageDecoder<Frame> {
    private final Connection.Factory factory;

    FramingFormatHandler(Connection.Factory factory) {
        this.factory = factory;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
        boolean handshakeSuccessful;
        boolean bl = handshakeSuccessful = frame.header.opcode == Message.Response.Type.READY.opcode || frame.header.opcode == Message.Response.Type.AUTHENTICATE.opcode;
        if (handshakeSuccessful) {
            if (frame.header.version.compareTo(ProtocolVersion.V5) >= 0) {
                this.switchToModernFraming(ctx);
            }
            ctx.pipeline().remove("framingFormatHandler");
        }
        out.add(frame);
    }

    private void switchToModernFraming(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        SegmentCodec segmentCodec = new SegmentCodec(ctx.channel().alloc(), this.factory.configuration.getProtocolOptions().getCompression());
        Message.ProtocolEncoder requestEncoder = (Message.ProtocolEncoder)pipeline.get("messageEncoder");
        pipeline.replace("messageEncoder", "messageToSegmentEncoder", (ChannelHandler)new MessageToSegmentEncoder(ctx.channel().alloc(), requestEncoder));
        pipeline.replace("frameEncoder", "segmentToBytesEncoder", (ChannelHandler)new SegmentToBytesEncoder(segmentCodec));
        pipeline.replace("frameDecoder", "bytesToSegmentDecoder", (ChannelHandler)new BytesToSegmentDecoder(segmentCodec));
        pipeline.addAfter("bytesToSegmentDecoder", "segmentToFrameDecoder", new SegmentToFrameDecoder());
    }
}

