/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;

public final class LocalDate {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final long millisSinceEpoch;
    private final int daysSinceEpoch;
    private volatile GregorianCalendar calendar;

    private LocalDate(int daysSinceEpoch) {
        this.daysSinceEpoch = daysSinceEpoch;
        this.millisSinceEpoch = TimeUnit.DAYS.toMillis(daysSinceEpoch);
    }

    public static LocalDate fromDaysSinceEpoch(int daysSinceEpoch) {
        return new LocalDate(daysSinceEpoch);
    }

    public static LocalDate fromMillisSinceEpoch(long millisSinceEpoch) throws IllegalArgumentException {
        long daysSinceEpoch = TimeUnit.MILLISECONDS.toDays(millisSinceEpoch);
        Preconditions.checkArgument(daysSinceEpoch >= Integer.MIN_VALUE && daysSinceEpoch <= Integer.MAX_VALUE, "Date should be in the range [-5877641-06-23; 5881580-07-11]");
        return new LocalDate((int)daysSinceEpoch);
    }

    public static LocalDate fromYearMonthDay(int year, int month, int dayOfMonth) {
        int calendarYear = year <= 0 ? -year + 1 : year;
        int calendarEra = year <= 0 ? 0 : 1;
        GregorianCalendar calendar = LocalDate.isoCalendar();
        calendar.setLenient(false);
        calendar.clear();
        calendar.set(calendarYear, month - 1, dayOfMonth, 0, 0, 0);
        calendar.set(0, calendarEra);
        LocalDate date = LocalDate.fromMillisSinceEpoch(calendar.getTimeInMillis());
        date.calendar = calendar;
        return date;
    }

    public int getDaysSinceEpoch() {
        return this.daysSinceEpoch;
    }

    public long getMillisSinceEpoch() {
        return this.millisSinceEpoch;
    }

    public int getYear() {
        GregorianCalendar c = this.getCalendar();
        int year = c.get(1);
        if (c.get(0) == 0) {
            year = -year + 1;
        }
        return year;
    }

    public int getMonth() {
        return this.getCalendar().get(2) + 1;
    }

    public int getDay() {
        return this.getCalendar().get(5);
    }

    public LocalDate add(int field, int amount) {
        GregorianCalendar newCalendar = LocalDate.isoCalendar();
        newCalendar.setTimeInMillis(this.millisSinceEpoch);
        newCalendar.add(field, amount);
        LocalDate newDate = LocalDate.fromMillisSinceEpoch(newCalendar.getTimeInMillis());
        newDate.calendar = newCalendar;
        return newDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LocalDate) {
            LocalDate that = (LocalDate)o;
            return this.daysSinceEpoch == that.daysSinceEpoch;
        }
        return false;
    }

    public int hashCode() {
        return this.daysSinceEpoch;
    }

    public String toString() {
        return String.format("%d-%s-%s", this.getYear(), LocalDate.pad2(this.getMonth()), LocalDate.pad2(this.getDay()));
    }

    private static String pad2(int i) {
        String s2 = Integer.toString(i);
        return s2.length() == 2 ? s2 : "0" + s2;
    }

    private GregorianCalendar getCalendar() {
        if (this.calendar == null) {
            GregorianCalendar tmp = LocalDate.isoCalendar();
            tmp.setTimeInMillis(this.millisSinceEpoch);
            this.calendar = tmp;
        }
        return this.calendar;
    }

    private static GregorianCalendar isoCalendar() {
        GregorianCalendar calendar = new GregorianCalendar(UTC);
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        return calendar;
    }
}

