/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableMap;

public class MapExtensionReader {
    private static final Logger logger = LoggerFactory.getLogger(MapExtensionReader.class);
    private final ByteBuffer rawData;

    public MapExtensionReader(ByteBuffer rawData) {
        this.rawData = Preconditions.checkNotNull(rawData).slice().order(ByteOrder.LITTLE_ENDIAN);
    }

    public Map<String, String> parse() {
        ImmutableMap.Builder<String, String> builder = new ImmutableMap.Builder<String, String>();
        int numElements = this.parseInt();
        Preconditions.checkArgument(numElements >= 0);
        for (int i = 0; i < numElements; ++i) {
            try {
                String key = this.parseString();
                String value = this.parseString();
                builder.put(key, value);
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                logger.warn("Encoding exception while parsing extension map metadata", (Throwable)ex);
            }
        }
        return builder.build();
    }

    private String parseString() throws UnsupportedEncodingException {
        int length = this.parseInt();
        byte[] rawString = new byte[length];
        this.rawData.get(rawString);
        return new String(rawString, "UTF-8");
    }

    private int parseInt() {
        return this.rawData.getInt();
    }
}

