/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import shaded.com.scylladb.cdc.driver3.buffer.ByteBufAllocator;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandlerContext;
import shaded.com.scylladb.cdc.driver3.channel.ChannelOutboundHandlerAdapter;
import shaded.com.scylladb.cdc.driver3.channel.ChannelPromise;
import shaded.com.scylladb.cdc.driver3.driver.core.Message;
import shaded.com.scylladb.cdc.driver3.driver.core.SegmentBuilder;

class MessageToSegmentEncoder
extends ChannelOutboundHandlerAdapter {
    private final ByteBufAllocator allocator;
    private final Message.ProtocolEncoder requestEncoder;
    private SegmentBuilder segmentBuilder;

    MessageToSegmentEncoder(ByteBufAllocator allocator, Message.ProtocolEncoder requestEncoder) {
        this.allocator = allocator;
        this.requestEncoder = requestEncoder;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.segmentBuilder = new SegmentBuilder(ctx, this.allocator, this.requestEncoder);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Message.Request) {
            this.segmentBuilder.addRequest((Message.Request)msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.segmentBuilder.flush();
        super.flush(ctx);
    }
}

