/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.concurrent.ThreadFactory;
import shaded.com.scylladb.cdc.driver3.bootstrap.Bootstrap;
import shaded.com.scylladb.cdc.driver3.buffer.PooledByteBufAllocator;
import shaded.com.scylladb.cdc.driver3.channel.ChannelOption;
import shaded.com.scylladb.cdc.driver3.channel.EventLoopGroup;
import shaded.com.scylladb.cdc.driver3.channel.socket.SocketChannel;
import shaded.com.scylladb.cdc.driver3.driver.core.NettyUtil;
import shaded.com.scylladb.cdc.driver3.util.HashedWheelTimer;
import shaded.com.scylladb.cdc.driver3.util.Timer;

public class NettyOptions {
    public static final NettyOptions DEFAULT_INSTANCE = new NettyOptions();

    public EventLoopGroup eventLoopGroup(ThreadFactory threadFactory) {
        return NettyUtil.newEventLoopGroupInstance(threadFactory);
    }

    public Class<? extends SocketChannel> channelClass() {
        return NettyUtil.channelClass();
    }

    public void afterBootstrapInitialized(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
    }

    public void afterChannelInitialized(SocketChannel channel) throws Exception {
    }

    public void onClusterClose(EventLoopGroup eventLoopGroup) {
        eventLoopGroup.shutdownGracefully().syncUninterruptibly();
    }

    public Timer timer(ThreadFactory threadFactory) {
        return new HashedWheelTimer(threadFactory);
    }

    public void onClusterClose(Timer timer) {
        timer.stop();
    }
}

