/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import shaded.com.scylladb.cdc.driver3.driver.core.BatchStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.BoundStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.StatementWrapper;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.PagingStateException;
import shaded.com.scylladb.cdc.driver3.driver.core.utils.Bytes;

public class PagingState {
    private final byte[] pagingState;
    private final byte[] hash;
    private final ProtocolVersion protocolVersion;

    PagingState(ByteBuffer pagingState, Statement statement, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this.pagingState = Bytes.getArray(pagingState);
        this.hash = this.hash(statement, protocolVersion, codecRegistry);
        this.protocolVersion = protocolVersion;
    }

    private PagingState(byte[] complete) {
        ByteBuffer pagingStateBB = ByteBuffer.wrap(complete);
        short pagingSize = pagingStateBB.getShort();
        short hashSize = pagingStateBB.getShort();
        if (pagingSize + hashSize != pagingStateBB.remaining() && pagingSize + hashSize + 2 != pagingStateBB.remaining()) {
            throw new PagingStateException("Cannot deserialize paging state, invalid format. The serialized form was corrupted, or not initially generated from a PagingState object.");
        }
        this.pagingState = new byte[pagingSize];
        pagingStateBB.get(this.pagingState);
        this.hash = new byte[hashSize];
        pagingStateBB.get(this.hash);
        this.protocolVersion = pagingStateBB.remaining() > 0 ? ProtocolVersion.fromInt(pagingStateBB.getShort()) : ProtocolVersion.V2;
    }

    private byte[] hash(Statement statement, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        byte[] digest;
        if (statement instanceof StatementWrapper) {
            statement = ((StatementWrapper)statement).getWrappedStatement();
        }
        assert (!(statement instanceof BatchStatement));
        try {
            ByteBuffer[] values;
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (statement instanceof BoundStatement) {
                BoundStatement bs = (BoundStatement)statement;
                md.update(bs.preparedStatement().getQueryString().getBytes());
                values = bs.wrapper.values;
            } else {
                ByteBuffer[] rs = (ByteBuffer[])statement;
                md.update(rs.getQueryString().getBytes());
                values = rs.getValues(protocolVersion, codecRegistry);
            }
            if (values != null) {
                for (ByteBuffer value : values) {
                    md.update(value.duplicate());
                }
            }
            md.update(this.pagingState);
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 doesn't seem to be available on this JVM", e);
        }
        return digest;
    }

    boolean matches(Statement statement, CodecRegistry codecRegistry) {
        byte[] toTest = this.hash(statement, this.protocolVersion, codecRegistry);
        return Arrays.equals(toTest, this.hash);
    }

    private ByteBuffer generateCompleteOutput() {
        ByteBuffer res = ByteBuffer.allocate(this.pagingState.length + this.hash.length + 6);
        res.putShort((short)this.pagingState.length);
        res.putShort((short)this.hash.length);
        res.put(this.pagingState);
        res.put(this.hash);
        res.putShort((short)this.protocolVersion.toInt());
        res.rewind();
        return res;
    }

    ByteBuffer getRawState() {
        return ByteBuffer.wrap(this.pagingState);
    }

    public String toString() {
        return Bytes.toRawHexString(this.generateCompleteOutput());
    }

    public static PagingState fromString(String string) {
        try {
            byte[] complete = Bytes.fromRawHexString(string, 0);
            return new PagingState(complete);
        }
        catch (Exception e) {
            throw new PagingStateException("Cannot deserialize paging state, invalid format. The serialized form was corrupted, or not initially generated from a PagingState object.", e);
        }
    }

    public byte[] toBytes() {
        return this.generateCompleteOutput().array();
    }

    public static PagingState fromBytes(byte[] pagingState) {
        return new PagingState(pagingState);
    }
}

