/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import shaded.com.scylladb.cdc.driver3.common.annotations.VisibleForTesting;
import shaded.com.scylladb.cdc.driver3.driver.core.AuthProvider;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.FrameCompressor;
import shaded.com.scylladb.cdc.driver3.driver.core.LZ4Compressor;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.SSLOptions;
import shaded.com.scylladb.cdc.driver3.driver.core.SnappyCompressor;

public class ProtocolOptions {
    public static final int DEFAULT_PORT = 9042;
    public static final int DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = 10;
    public static final int DEFAULT_LOCAL_PORT_LOW = 10000;
    public static final int DEFAULT_LOCAL_PORT_HIGH = 60000;
    private volatile Cluster.Manager manager;
    private final int port;
    final ProtocolVersion initialProtocolVersion;
    @VisibleForTesting
    volatile int maxSchemaAgreementWaitSeconds;
    private final SSLOptions sslOptions;
    private final AuthProvider authProvider;
    private final boolean noCompact;
    private volatile Compression compression = Compression.NONE;
    private final boolean useAdvancedShardAwarness;
    private final int localPortLow;
    private final int localPortHigh;

    public ProtocolOptions() {
        this(9042);
    }

    public ProtocolOptions(int port) {
        this(port, null, 10, null, AuthProvider.NONE, false);
    }

    public ProtocolOptions(int port, ProtocolVersion protocolVersion, int maxSchemaAgreementWaitSeconds, SSLOptions sslOptions, AuthProvider authProvider) {
        this(port, protocolVersion, maxSchemaAgreementWaitSeconds, sslOptions, authProvider, false);
    }

    public ProtocolOptions(int port, ProtocolVersion protocolVersion, int maxSchemaAgreementWaitSeconds, SSLOptions sslOptions, AuthProvider authProvider, boolean noCompact) {
        this(port, protocolVersion, maxSchemaAgreementWaitSeconds, sslOptions, authProvider, noCompact, true, 10000, 60000);
    }

    public ProtocolOptions(int port, ProtocolVersion protocolVersion, int maxSchemaAgreementWaitSeconds, SSLOptions sslOptions, AuthProvider authProvider, boolean noCompact, boolean useAdvancedShardAwarness, int portLow, int portHigh) {
        this.port = port;
        this.initialProtocolVersion = protocolVersion;
        this.maxSchemaAgreementWaitSeconds = maxSchemaAgreementWaitSeconds;
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
        this.noCompact = noCompact;
        this.useAdvancedShardAwarness = useAdvancedShardAwarness;
        this.localPortLow = portLow;
        this.localPortHigh = portHigh;
    }

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getPort() {
        return this.port;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.manager == null || this.manager.connectionFactory == null ? null : this.manager.connectionFactory.protocolVersion;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ProtocolOptions setCompression(Compression compression) {
        if (compression != Compression.NONE && compression.compressor() == null) {
            throw new IllegalStateException("The requested compression is not available (some compression require a JAR to be found in the classpath)");
        }
        this.compression = compression;
        return this;
    }

    public int getMaxSchemaAgreementWaitSeconds() {
        return this.maxSchemaAgreementWaitSeconds;
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public boolean isNoCompact() {
        return this.noCompact;
    }

    public boolean isUseAdvancedShardAwareness() {
        return this.useAdvancedShardAwarness;
    }

    public int getLowLocalPort() {
        return this.localPortLow;
    }

    public int getHighLocalPort() {
        return this.localPortHigh;
    }

    public static enum Compression {
        NONE(""){

            @Override
            FrameCompressor compressor() {
                return null;
            }
        }
        ,
        SNAPPY("snappy"){

            @Override
            FrameCompressor compressor() {
                return SnappyCompressor.instance;
            }
        }
        ,
        LZ4("lz4"){

            @Override
            FrameCompressor compressor() {
                return LZ4Compressor.instance;
            }
        };

        final String protocolName;

        private Compression(String protocolName) {
            this.protocolName = protocolName;
        }

        abstract FrameCompressor compressor();

        static Compression fromString(String str) {
            for (Compression c : Compression.values()) {
                if (!c.protocolName.equalsIgnoreCase(str)) continue;
                return c;
            }
            return null;
        }

        public String toString() {
            return this.protocolName;
        }
    }
}

