/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.scylladb.cdc.driver3.common.annotations.VisibleForTesting;
import shaded.com.scylladb.cdc.driver3.driver.core.BatchStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.BoundStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.CancelledSpeculativeExecutionException;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnDefinitions;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.LatencyTracker;
import shaded.com.scylladb.cdc.driver3.driver.core.PercentileTracker;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.RegularStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.SimpleStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.StatementWrapper;
import shaded.com.scylladb.cdc.driver3.driver.core.TypeCodec;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.BuiltStatement;

public abstract class QueryLogger
implements LatencyTracker {
    public static final long DEFAULT_SLOW_QUERY_THRESHOLD_MS = 5000L;
    public static final double DEFAULT_SLOW_QUERY_THRESHOLD_PERCENTILE = 99.0;
    public static final int DEFAULT_MAX_QUERY_STRING_LENGTH = 500;
    public static final int DEFAULT_MAX_PARAMETER_VALUE_LENGTH = 50;
    public static final int DEFAULT_MAX_LOGGED_PARAMETERS = 50;
    public static final Logger NORMAL_LOGGER = LoggerFactory.getLogger((String)"shaded.com.scylladb.cdc.driver3.driver.core.QueryLogger.NORMAL");
    public static final Logger SLOW_LOGGER = LoggerFactory.getLogger((String)"shaded.com.scylladb.cdc.driver3.driver.core.QueryLogger.SLOW");
    public static final Logger ERROR_LOGGER = LoggerFactory.getLogger((String)"shaded.com.scylladb.cdc.driver3.driver.core.QueryLogger.ERROR");
    private static final String NORMAL_TEMPLATE = "[%s] [%s] Query completed normally, took %s ms: %s";
    private static final String SLOW_TEMPLATE_MILLIS = "[%s] [%s] Query too slow, took %s ms: %s";
    private static final String SLOW_TEMPLATE_PERCENTILE = "[%s] [%s] Query too slow, took %s ms (%s percentile = %s ms): %s";
    private static final String ERROR_TEMPLATE = "[%s] [%s] Query error after %s ms: %s";
    @VisibleForTesting
    static final String TRUNCATED_OUTPUT = "... [truncated output]";
    @VisibleForTesting
    static final String FURTHER_PARAMS_OMITTED = " [further parameters omitted]";
    protected volatile Cluster cluster;
    private volatile ProtocolVersion protocolVersion;
    protected volatile int maxQueryStringLength;
    protected volatile int maxParameterValueLength;
    protected volatile int maxLoggedParameters;

    private QueryLogger(int maxQueryStringLength, int maxParameterValueLength, int maxLoggedParameters) {
        this.maxQueryStringLength = maxQueryStringLength;
        this.maxParameterValueLength = maxParameterValueLength;
        this.maxLoggedParameters = maxLoggedParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void onRegister(Cluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public void onUnregister(Cluster cluster) {
    }

    public int getMaxQueryStringLength() {
        return this.maxQueryStringLength;
    }

    public void setMaxQueryStringLength(int maxQueryStringLength) {
        if (maxQueryStringLength <= 0 && maxQueryStringLength != -1) {
            throw new IllegalArgumentException("Invalid maxQueryStringLength, should be > 0 or -1, got " + maxQueryStringLength);
        }
        this.maxQueryStringLength = maxQueryStringLength;
    }

    public int getMaxParameterValueLength() {
        return this.maxParameterValueLength;
    }

    public void setMaxParameterValueLength(int maxParameterValueLength) {
        if (maxParameterValueLength <= 0 && maxParameterValueLength != -1) {
            throw new IllegalArgumentException("Invalid maxParameterValueLength, should be > 0 or -1, got " + maxParameterValueLength);
        }
        this.maxParameterValueLength = maxParameterValueLength;
    }

    public int getMaxLoggedParameters() {
        return this.maxLoggedParameters;
    }

    public void setMaxLoggedParameters(int maxLoggedParameters) {
        if (maxLoggedParameters <= 0 && maxLoggedParameters != -1) {
            throw new IllegalArgumentException("Invalid maxLoggedParameters, should be > 0 or -1, got " + maxLoggedParameters);
        }
        this.maxLoggedParameters = maxLoggedParameters;
    }

    @Override
    public void update(Host host, Statement statement, Exception exception, long newLatencyNanos) {
        if (this.cluster == null) {
            throw new IllegalStateException("This method should only be called after the logger has been registered with a cluster");
        }
        if (statement instanceof StatementWrapper) {
            statement = ((StatementWrapper)statement).getWrappedStatement();
        }
        long latencyMs = TimeUnit.NANOSECONDS.toMillis(newLatencyNanos);
        if (exception == null) {
            this.maybeLogNormalOrSlowQuery(host, statement, latencyMs);
        } else {
            this.maybeLogErrorQuery(host, statement, exception, latencyMs);
        }
    }

    protected abstract void maybeLogNormalOrSlowQuery(Host var1, Statement var2, long var3);

    protected void maybeLogNormalQuery(Host host, Statement statement, long latencyMs) {
        if (NORMAL_LOGGER.isDebugEnabled()) {
            String message = String.format(NORMAL_TEMPLATE, this.cluster.getClusterName(), host, latencyMs, this.statementAsString(statement));
            this.logQuery(statement, null, NORMAL_LOGGER, message);
        }
    }

    protected void maybeLogErrorQuery(Host host, Statement statement, Exception exception, long latencyMs) {
        if (ERROR_LOGGER.isDebugEnabled() && !(exception instanceof CancelledSpeculativeExecutionException)) {
            String message = String.format(ERROR_TEMPLATE, this.cluster.getClusterName(), host, latencyMs, this.statementAsString(statement));
            this.logQuery(statement, exception, ERROR_LOGGER, message);
        }
    }

    protected void logQuery(Statement statement, Exception exception, Logger logger, String message) {
        boolean showParameterValues = logger.isTraceEnabled();
        if (showParameterValues) {
            StringBuilder params = new StringBuilder();
            if (statement instanceof BoundStatement) {
                this.appendParameters((BoundStatement)statement, params, this.maxLoggedParameters);
            } else if (statement instanceof SimpleStatement) {
                this.appendParameters((SimpleStatement)statement, params, this.maxLoggedParameters);
            } else if (statement instanceof BatchStatement) {
                BatchStatement batchStatement = (BatchStatement)statement;
                int remaining = this.maxLoggedParameters;
                for (Statement inner : batchStatement.getStatements()) {
                    if (inner instanceof BoundStatement) {
                        remaining = this.appendParameters((BoundStatement)inner, params, remaining);
                        continue;
                    }
                    if (!(inner instanceof SimpleStatement)) continue;
                    remaining = this.appendParameters((SimpleStatement)inner, params, remaining);
                }
            } else if (statement instanceof BuiltStatement) {
                this.appendParameters((BuiltStatement)statement, params, this.maxLoggedParameters);
            }
            if (params.length() > 0) {
                params.append("]");
            }
            logger.trace(message + params, (Throwable)exception);
        } else {
            logger.debug(message, (Throwable)exception);
        }
    }

    protected String statementAsString(Statement statement) {
        StringBuilder sb = new StringBuilder();
        if (statement instanceof BatchStatement) {
            BatchStatement bs = (BatchStatement)statement;
            int statements = bs.getStatements().size();
            int boundValues = this.countBoundValues(bs);
            sb.append("[" + statements + " statements, " + boundValues + " bound values] ");
        } else if (statement instanceof BoundStatement) {
            int boundValues = ((BoundStatement)statement).wrapper.values.length;
            sb.append("[" + boundValues + " bound values] ");
        } else if (statement instanceof SimpleStatement) {
            int boundValues = ((SimpleStatement)statement).valuesCount();
            sb.append("[" + boundValues + " bound values] ");
        }
        this.append(statement, sb, this.maxQueryStringLength);
        return sb.toString();
    }

    protected int countBoundValues(BatchStatement bs) {
        int count = 0;
        for (Statement s2 : bs.getStatements()) {
            if (s2 instanceof BoundStatement) {
                count += ((BoundStatement)s2).wrapper.values.length;
                continue;
            }
            if (!(s2 instanceof SimpleStatement)) continue;
            count += ((SimpleStatement)s2).valuesCount();
        }
        return count;
    }

    protected int appendParameters(BoundStatement statement, StringBuilder buffer, int remaining) {
        if (remaining == 0) {
            return 0;
        }
        ColumnDefinitions metadata = statement.preparedStatement().getVariables();
        int numberOfParameters = metadata.size();
        if (numberOfParameters > 0) {
            int numberOfLoggedParameters;
            List<ColumnDefinitions.Definition> definitions = metadata.asList();
            if (remaining == -1) {
                numberOfLoggedParameters = numberOfParameters;
            } else {
                numberOfLoggedParameters = Math.min(remaining, numberOfParameters);
                remaining -= numberOfLoggedParameters;
            }
            for (int i = 0; i < numberOfLoggedParameters; ++i) {
                if (buffer.length() == 0) {
                    buffer.append(" [");
                } else {
                    buffer.append(", ");
                }
                String value = statement.isSet(i) ? this.parameterValueAsString(definitions.get(i), statement.wrapper.values[i]) : "<UNSET>";
                buffer.append(String.format("%s:%s", metadata.getName(i), value));
            }
            if (numberOfLoggedParameters < numberOfParameters) {
                buffer.append(FURTHER_PARAMS_OMITTED);
            }
        }
        return remaining;
    }

    protected String parameterValueAsString(ColumnDefinitions.Definition definition, ByteBuffer raw) {
        String valueStr;
        if (raw == null || raw.remaining() == 0) {
            valueStr = "NULL";
        } else {
            DataType type = definition.getType();
            CodecRegistry codecRegistry = this.cluster.getConfiguration().getCodecRegistry();
            TypeCodec codec = codecRegistry.codecFor(type);
            int maxParameterValueLength = this.maxParameterValueLength;
            if (type.equals(DataType.blob()) && maxParameterValueLength != -1) {
                boolean bufferTooLarge;
                int maxBufferLength = Math.max(2, (maxParameterValueLength - 2) / 2);
                boolean bl = bufferTooLarge = raw.remaining() > maxBufferLength;
                if (bufferTooLarge) {
                    raw = (ByteBuffer)raw.duplicate().limit(maxBufferLength);
                }
                Object value = codec.deserialize(raw, this.protocolVersion());
                valueStr = codec.format(value);
                if (bufferTooLarge) {
                    valueStr = valueStr + TRUNCATED_OUTPUT;
                }
            } else {
                Object value = codec.deserialize(raw, this.protocolVersion());
                valueStr = codec.format(value);
                if (maxParameterValueLength != -1 && valueStr.length() > maxParameterValueLength) {
                    valueStr = valueStr.substring(0, maxParameterValueLength) + TRUNCATED_OUTPUT;
                }
            }
        }
        return valueStr;
    }

    protected int appendParameters(SimpleStatement statement, StringBuilder buffer, int remaining) {
        if (remaining == 0) {
            return 0;
        }
        int numberOfParameters = statement.valuesCount();
        if (numberOfParameters > 0) {
            int numberOfLoggedParameters;
            if (remaining == -1) {
                numberOfLoggedParameters = numberOfParameters;
            } else {
                numberOfLoggedParameters = remaining > numberOfParameters ? numberOfParameters : remaining;
                remaining -= numberOfLoggedParameters;
            }
            Iterator<String> valueNames = null;
            if (statement.usesNamedValues()) {
                valueNames = statement.getValueNames().iterator();
            }
            for (int i = 0; i < numberOfLoggedParameters; ++i) {
                if (buffer.length() == 0) {
                    buffer.append(" [");
                } else {
                    buffer.append(", ");
                }
                if (valueNames != null && valueNames.hasNext()) {
                    String valueName = valueNames.next();
                    buffer.append(String.format("%s:%s", valueName, this.parameterValueAsString(statement.getObject(valueName))));
                    continue;
                }
                buffer.append(this.parameterValueAsString(statement.getObject(i)));
            }
            if (numberOfLoggedParameters < numberOfParameters) {
                buffer.append(FURTHER_PARAMS_OMITTED);
            }
        }
        return remaining;
    }

    protected String parameterValueAsString(Object value) {
        String valueStr;
        if (value == null) {
            valueStr = "NULL";
        } else {
            CodecRegistry codecRegistry = this.cluster.getConfiguration().getCodecRegistry();
            TypeCodec<Object> codec = codecRegistry.codecFor(value);
            int maxParameterValueLength = this.maxParameterValueLength;
            if (codec.cqlType.equals(DataType.blob()) && maxParameterValueLength != -1) {
                boolean bufferTooLarge;
                ByteBuffer buf = (ByteBuffer)value;
                int maxBufferLength = Math.max(2, (maxParameterValueLength - 2) / 2);
                boolean bl = bufferTooLarge = buf.remaining() > maxBufferLength;
                if (bufferTooLarge) {
                    value = (ByteBuffer)buf.duplicate().limit(maxBufferLength);
                }
                valueStr = codec.format(value);
                if (bufferTooLarge) {
                    valueStr = valueStr + TRUNCATED_OUTPUT;
                }
            } else {
                valueStr = codec.format(value);
                if (maxParameterValueLength != -1 && valueStr.length() > maxParameterValueLength) {
                    valueStr = valueStr.substring(0, maxParameterValueLength) + TRUNCATED_OUTPUT;
                }
            }
        }
        return valueStr;
    }

    protected int appendParameters(BuiltStatement statement, StringBuilder buffer, int remaining) {
        int numberOfParameters;
        if (remaining == 0) {
            return 0;
        }
        ByteBuffer[] values = statement.getValues(this.protocolVersion(), this.cluster.getConfiguration().getCodecRegistry());
        int n = numberOfParameters = values == null ? 0 : values.length;
        if (numberOfParameters > 0) {
            int numberOfLoggedParameters;
            if (remaining == -1) {
                numberOfLoggedParameters = numberOfParameters;
            } else {
                numberOfLoggedParameters = remaining > numberOfParameters ? numberOfParameters : remaining;
                remaining -= numberOfLoggedParameters;
            }
            for (int i = 0; i < numberOfLoggedParameters; ++i) {
                if (buffer.length() == 0) {
                    buffer.append(" [");
                } else {
                    buffer.append(", ");
                }
                buffer.append(this.parameterValueAsString(statement.getObject(i)));
            }
            if (numberOfLoggedParameters < numberOfParameters) {
                buffer.append(FURTHER_PARAMS_OMITTED);
            }
        }
        return remaining;
    }

    private ProtocolVersion protocolVersion() {
        if (this.protocolVersion == null) {
            this.protocolVersion = this.cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
            assert (this.protocolVersion != null) : "protocol version should be defined";
        }
        return this.protocolVersion;
    }

    protected int append(Statement statement, StringBuilder buffer, int remaining) {
        if (statement instanceof RegularStatement) {
            RegularStatement rs = (RegularStatement)statement;
            String query = rs.getQueryString();
            remaining = this.append(query.trim(), buffer, remaining);
        } else if (statement instanceof BoundStatement) {
            remaining = this.append(((BoundStatement)statement).preparedStatement().getQueryString().trim(), buffer, remaining);
        } else if (statement instanceof BatchStatement) {
            BatchStatement batchStatement = (BatchStatement)statement;
            remaining = this.append("BEGIN", buffer, remaining);
            switch (batchStatement.batchType) {
                case UNLOGGED: {
                    this.append(" UNLOGGED", buffer, remaining);
                    break;
                }
                case COUNTER: {
                    this.append(" COUNTER", buffer, remaining);
                }
            }
            remaining = this.append(" BATCH", buffer, remaining);
            for (Statement stmt : batchStatement.getStatements()) {
                remaining = this.append(" ", buffer, remaining);
                remaining = this.append(stmt, buffer, remaining);
            }
            remaining = this.append(" APPLY BATCH", buffer, remaining);
        } else {
            remaining = this.append(statement.toString(), buffer, remaining);
        }
        if (buffer.charAt(buffer.length() - 1) != ';') {
            remaining = this.append(";", buffer, remaining);
        }
        return remaining;
    }

    protected int append(CharSequence str, StringBuilder buffer, int remaining) {
        if (remaining != -2) {
            if (remaining == -1) {
                buffer.append(str);
            } else if (str.length() > remaining) {
                buffer.append(str, 0, remaining).append(TRUNCATED_OUTPUT);
                remaining = -2;
            } else {
                buffer.append(str);
                remaining -= str.length();
            }
        }
        return remaining;
    }

    public static class Builder {
        private int maxQueryStringLength = 500;
        private int maxParameterValueLength = 50;
        private int maxLoggedParameters = 50;
        private long slowQueryLatencyThresholdMillis = 5000L;
        private double slowQueryLatencyThresholdPercentile = 99.0;
        private PercentileTracker percentileLatencyTracker;
        private boolean constantThreshold = true;

        public Builder withConstantThreshold(long slowQueryLatencyThresholdMillis) {
            this.slowQueryLatencyThresholdMillis = slowQueryLatencyThresholdMillis;
            this.constantThreshold = true;
            return this;
        }

        public Builder withDynamicThreshold(PercentileTracker percentileLatencyTracker, double slowQueryLatencyThresholdPercentile) {
            this.percentileLatencyTracker = percentileLatencyTracker;
            this.slowQueryLatencyThresholdPercentile = slowQueryLatencyThresholdPercentile;
            this.constantThreshold = false;
            return this;
        }

        public Builder withMaxQueryStringLength(int maxQueryStringLength) {
            this.maxQueryStringLength = maxQueryStringLength;
            return this;
        }

        public Builder withMaxParameterValueLength(int maxParameterValueLength) {
            this.maxParameterValueLength = maxParameterValueLength;
            return this;
        }

        public Builder withMaxLoggedParameters(int maxLoggedParameters) {
            this.maxLoggedParameters = maxLoggedParameters;
            return this;
        }

        public QueryLogger build() {
            if (this.constantThreshold) {
                return new ConstantThresholdQueryLogger(this.maxQueryStringLength, this.maxParameterValueLength, this.maxLoggedParameters, this.slowQueryLatencyThresholdMillis);
            }
            return new DynamicThresholdQueryLogger(this.maxQueryStringLength, this.maxParameterValueLength, this.maxLoggedParameters, this.slowQueryLatencyThresholdPercentile, this.percentileLatencyTracker);
        }
    }

    public static class DynamicThresholdQueryLogger
    extends QueryLogger {
        private volatile double slowQueryLatencyThresholdPercentile;
        private volatile PercentileTracker percentileLatencyTracker;

        private DynamicThresholdQueryLogger(int maxQueryStringLength, int maxParameterValueLength, int maxLoggedParameters, double slowQueryLatencyThresholdPercentile, PercentileTracker percentileLatencyTracker) {
            super(maxQueryStringLength, maxParameterValueLength, maxLoggedParameters);
            this.setSlowQueryLatencyThresholdPercentile(slowQueryLatencyThresholdPercentile);
            this.setPercentileLatencyTracker(percentileLatencyTracker);
        }

        public PercentileTracker getPercentileLatencyTracker() {
            return this.percentileLatencyTracker;
        }

        public void setPercentileLatencyTracker(PercentileTracker percentileLatencyTracker) {
            if (percentileLatencyTracker == null) {
                throw new IllegalArgumentException("perHostPercentileLatencyTracker cannot be null");
            }
            this.percentileLatencyTracker = percentileLatencyTracker;
        }

        public double getSlowQueryLatencyThresholdPercentile() {
            return this.slowQueryLatencyThresholdPercentile;
        }

        public void setSlowQueryLatencyThresholdPercentile(double slowQueryLatencyThresholdPercentile) {
            if (slowQueryLatencyThresholdPercentile < 0.0 || slowQueryLatencyThresholdPercentile >= 100.0) {
                throw new IllegalArgumentException("Invalid slowQueryLatencyThresholdPercentile, should be >= 0 and < 100, got " + slowQueryLatencyThresholdPercentile);
            }
            this.slowQueryLatencyThresholdPercentile = slowQueryLatencyThresholdPercentile;
        }

        @Override
        protected void maybeLogNormalOrSlowQuery(Host host, Statement statement, long latencyMs) {
            long threshold = this.percentileLatencyTracker.getLatencyAtPercentile(host, statement, null, this.slowQueryLatencyThresholdPercentile);
            if (threshold >= 0L && latencyMs > threshold) {
                this.maybeLogSlowQuery(host, statement, latencyMs, threshold);
            } else {
                this.maybeLogNormalQuery(host, statement, latencyMs);
            }
        }

        protected void maybeLogSlowQuery(Host host, Statement statement, long latencyMs, long threshold) {
            if (SLOW_LOGGER.isDebugEnabled()) {
                String message = String.format(QueryLogger.SLOW_TEMPLATE_PERCENTILE, this.cluster.getClusterName(), host, latencyMs, this.slowQueryLatencyThresholdPercentile, threshold, this.statementAsString(statement));
                this.logQuery(statement, null, SLOW_LOGGER, message);
            }
        }

        @Override
        public void onRegister(Cluster cluster) {
            super.onRegister(cluster);
            cluster.register(this.percentileLatencyTracker);
        }
    }

    public static class ConstantThresholdQueryLogger
    extends QueryLogger {
        private volatile long slowQueryLatencyThresholdMillis;

        private ConstantThresholdQueryLogger(int maxQueryStringLength, int maxParameterValueLength, int maxLoggedParameters, long slowQueryLatencyThresholdMillis) {
            super(maxQueryStringLength, maxParameterValueLength, maxLoggedParameters);
            this.setSlowQueryLatencyThresholdMillis(slowQueryLatencyThresholdMillis);
        }

        public long getSlowQueryLatencyThresholdMillis() {
            return this.slowQueryLatencyThresholdMillis;
        }

        public void setSlowQueryLatencyThresholdMillis(long slowQueryLatencyThresholdMillis) {
            if (slowQueryLatencyThresholdMillis <= 0L) {
                throw new IllegalArgumentException("Invalid slowQueryLatencyThresholdMillis, should be > 0, got " + slowQueryLatencyThresholdMillis);
            }
            this.slowQueryLatencyThresholdMillis = slowQueryLatencyThresholdMillis;
        }

        @Override
        protected void maybeLogNormalOrSlowQuery(Host host, Statement statement, long latencyMs) {
            if (latencyMs > this.slowQueryLatencyThresholdMillis) {
                this.maybeLogSlowQuery(host, statement, latencyMs);
            } else {
                this.maybeLogNormalQuery(host, statement, latencyMs);
            }
        }

        protected void maybeLogSlowQuery(Host host, Statement statement, long latencyMs) {
            if (SLOW_LOGGER.isDebugEnabled()) {
                String message = String.format(QueryLogger.SLOW_TEMPLATE_MILLIS, this.cluster.getClusterName(), host, latencyMs, this.statementAsString(statement));
                this.logQuery(statement, null, SLOW_LOGGER, message);
            }
        }
    }
}

