/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.util.Map;
import shaded.com.scylladb.cdc.driver3.driver.core.CBUtil;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.Frame;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolFeature;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.Requests;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;

public abstract class RegularStatement
extends Statement {
    protected RegularStatement() {
    }

    public abstract String getQueryString(CodecRegistry var1);

    public String getQueryString() {
        return this.getQueryString(CodecRegistry.DEFAULT_INSTANCE);
    }

    public abstract ByteBuffer[] getValues(ProtocolVersion var1, CodecRegistry var2);

    public abstract Map<String, ByteBuffer> getNamedValues(ProtocolVersion var1, CodecRegistry var2);

    public abstract boolean hasValues(CodecRegistry var1);

    public abstract boolean usesNamedValues();

    public boolean hasValues() {
        return this.hasValues(CodecRegistry.DEFAULT_INSTANCE);
    }

    @Override
    public int requestSizeInBytes(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int size = Frame.Header.lengthFor(protocolVersion);
        try {
            size += CBUtil.sizeOfLongString(this.getQueryString(codecRegistry));
            switch (protocolVersion) {
                case V1: {
                    size += CBUtil.sizeOfConsistencyLevel(this.getConsistencyLevel());
                    break;
                }
                case V2: 
                case V3: 
                case V4: 
                case V5: 
                case V6: {
                    size += CBUtil.sizeOfConsistencyLevel(this.getConsistencyLevel());
                    size += Requests.QueryFlag.serializedSize(protocolVersion);
                    if (this.hasValues()) {
                        size = this.usesNamedValues() ? (size += CBUtil.sizeOfNamedValueList(this.getNamedValues(protocolVersion, codecRegistry))) : (size += CBUtil.sizeOfValueList(this.getValues(protocolVersion, codecRegistry)));
                    }
                    size += 4;
                    if (this.getPagingState() != null) {
                        size += CBUtil.sizeOfValue(this.getPagingState());
                    }
                    size += CBUtil.sizeOfConsistencyLevel(this.getSerialConsistencyLevel());
                    if (ProtocolFeature.CLIENT_TIMESTAMPS.isSupportedBy(protocolVersion)) {
                        size += 8;
                    }
                    if (ProtocolFeature.CUSTOM_PAYLOADS.isSupportedBy(protocolVersion) && this.getOutgoingPayload() != null) {
                        size += CBUtil.sizeOfBytesMap(this.getOutgoingPayload());
                    }
                    break;
                }
                default: {
                    throw protocolVersion.unsupported();
                }
            }
        }
        catch (Exception e) {
            size = -1;
        }
        return size;
    }

    public String toString() {
        return this.getQueryString();
    }
}

