/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.scylladb.cdc.driver3.common.collect.Lists;
import shaded.com.scylladb.cdc.driver3.common.collect.Maps;
import shaded.com.scylladb.cdc.driver3.driver.core.AggregateMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Connection;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.DataTypeCqlNameParser;
import shaded.com.scylladb.cdc.driver3.driver.core.DefaultResultSetFuture;
import shaded.com.scylladb.cdc.driver3.driver.core.DirectedGraph;
import shaded.com.scylladb.cdc.driver3.driver.core.FunctionMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.KeyspaceMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.MaterializedViewMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Metadata;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.Requests;
import shaded.com.scylladb.cdc.driver3.driver.core.ResultSet;
import shaded.com.scylladb.cdc.driver3.driver.core.ResultSetFuture;
import shaded.com.scylladb.cdc.driver3.driver.core.Row;
import shaded.com.scylladb.cdc.driver3.driver.core.SchemaElement;
import shaded.com.scylladb.cdc.driver3.driver.core.TableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.TupleType;
import shaded.com.scylladb.cdc.driver3.driver.core.TypeCodec;
import shaded.com.scylladb.cdc.driver3.driver.core.UserType;
import shaded.com.scylladb.cdc.driver3.driver.core.VersionNumber;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.BusyConnectionException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.ConnectionException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.InvalidQueryException;

abstract class SchemaParser {
    private static final Logger logger = LoggerFactory.getLogger(SchemaParser.class);
    private static final TypeCodec<List<String>> LIST_OF_TEXT_CODEC = TypeCodec.list(TypeCodec.varchar());
    private static final SchemaParser V2_PARSER = new V2SchemaParser();
    private static final SchemaParser V3_PARSER = new V3SchemaParser();
    private static final SchemaParser V4_PARSER = new V4SchemaParser();
    private static final String SELECT_SCYLLA_KEYSPACES = "SELECT * FROM system_schema.scylla_keyspaces";

    SchemaParser() {
    }

    static SchemaParser forVersion(VersionNumber cassandraVersion) {
        if (cassandraVersion.getMajor() >= 4) {
            return V4_PARSER;
        }
        if (cassandraVersion.getMajor() >= 3) {
            return V3_PARSER;
        }
        return V2_PARSER;
    }

    static SchemaParser forDseVersion(VersionNumber dseVersion) {
        if (dseVersion.getMajor() == 6 && dseVersion.getMinor() >= 8) {
            return V4_PARSER;
        }
        if (dseVersion.getMajor() >= 5) {
            return V3_PARSER;
        }
        return V2_PARSER;
    }

    abstract SystemRows fetchSystemRows(Cluster var1, SchemaElement var2, String var3, String var4, List<String> var5, Connection var6, VersionNumber var7) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException;

    abstract String tableNameColumn();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void refresh(Cluster cluster, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
        Metadata metadata;
        SystemRows rows = this.fetchSystemRows(cluster, targetType, targetKeyspace, targetName, targetSignature, connection, cassandraVersion);
        try {
            metadata = cluster.getMetadata();
        }
        catch (IllegalStateException e) {
            logger.warn("Unable to refresh metadata, cluster has been closed");
            return;
        }
        metadata.lock.lock();
        try {
            if (targetType == null || targetType == SchemaElement.KEYSPACE) {
                assert (rows.keyspaces != null);
                Map<String, KeyspaceMetadata> keyspaces = this.buildKeyspaces(rows, cassandraVersion, cluster);
                this.updateKeyspaces(metadata, metadata.keyspaces, keyspaces, targetKeyspace);
                metadata.rebuildTokenMap();
                return;
            }
            assert (targetKeyspace != null);
            KeyspaceMetadata keyspace = (KeyspaceMetadata)metadata.keyspaces.get(targetKeyspace);
            if (keyspace == null) {
                logger.info(String.format("Asked to rebuild %s %s.%s but I don't know keyspace %s", new Object[]{targetType, targetKeyspace, targetName, targetKeyspace}));
                metadata.cluster.submitSchemaRefresh(null, null, null, null);
                return;
            }
            switch (targetType) {
                case TABLE: {
                    if (rows.tables.containsKey(targetKeyspace)) {
                        Map<String, TableMetadata> map = this.buildTables(keyspace, rows.tables.get(targetKeyspace), rows.columns.get(targetKeyspace), rows.indexes.get(targetKeyspace), cassandraVersion, cluster);
                        this.updateTables(metadata, keyspace.tables, map, targetName);
                    }
                    if (!rows.views.containsKey(targetKeyspace)) return;
                    Map<String, MaterializedViewMetadata> map = this.buildViews(keyspace, rows.views.get(targetKeyspace), rows.columns.get(targetKeyspace), cassandraVersion, cluster);
                    this.updateViews(metadata, keyspace.views, map, targetName);
                    return;
                }
                case TYPE: {
                    if (!rows.udts.containsKey(targetKeyspace)) return;
                    Map<String, UserType> map = this.buildUserTypes(keyspace, rows.udts.get(targetKeyspace), cassandraVersion, cluster);
                    this.updateUserTypes(metadata, keyspace.userTypes, map, targetName);
                    return;
                }
                case FUNCTION: {
                    if (!rows.functions.containsKey(targetKeyspace)) return;
                    Map<String, FunctionMetadata> map = this.buildFunctions(keyspace, rows.functions.get(targetKeyspace), cassandraVersion, cluster);
                    this.updateFunctions(metadata, keyspace.functions, map, targetName);
                    return;
                }
                case AGGREGATE: {
                    if (!rows.aggregates.containsKey(targetKeyspace)) return;
                    Map<String, AggregateMetadata> map = this.buildAggregates(keyspace, rows.aggregates.get(targetKeyspace), cassandraVersion, cluster);
                    this.updateAggregates(metadata, keyspace.aggregates, map, targetName);
                    return;
                }
            }
            return;
        }
        catch (RuntimeException e) {
            logger.error("Error parsing schema from Cassandra system tables: the schema in Cluster#getMetadata() will appear incomplete or stale", (Throwable)e);
            return;
        }
        finally {
            metadata.lock.unlock();
        }
    }

    private Map<String, KeyspaceMetadata> buildKeyspaces(SystemRows rows, VersionNumber cassandraVersion, Cluster cluster) {
        KeyspaceMetadata keyspace;
        LinkedHashMap<String, KeyspaceMetadata> keyspaces = new LinkedHashMap<String, KeyspaceMetadata>();
        for (Row keyspaceRow : rows.keyspaces) {
            Object aggregate2;
            Object table2;
            keyspace = KeyspaceMetadata.build(keyspaceRow, cassandraVersion);
            Map<String, UserType> userTypes = this.buildUserTypes(keyspace, rows.udts.get(keyspace.getName()), cassandraVersion, cluster);
            for (UserType userType : userTypes.values()) {
                keyspace.add(userType);
            }
            Map<String, TableMetadata> tables = this.buildTables(keyspace, rows.tables.get(keyspace.getName()), rows.columns.get(keyspace.getName()), rows.indexes.get(keyspace.getName()), cassandraVersion, cluster);
            for (Object table2 : tables.values()) {
                keyspace.add((TableMetadata)table2);
            }
            Map<String, FunctionMetadata> map = this.buildFunctions(keyspace, rows.functions.get(keyspace.getName()), cassandraVersion, cluster);
            table2 = map.values().iterator();
            while (table2.hasNext()) {
                FunctionMetadata functionMetadata = (FunctionMetadata)table2.next();
                keyspace.add(functionMetadata);
            }
            Map<String, AggregateMetadata> aggregates = this.buildAggregates(keyspace, rows.aggregates.get(keyspace.getName()), cassandraVersion, cluster);
            for (Object aggregate2 : aggregates.values()) {
                keyspace.add((AggregateMetadata)aggregate2);
            }
            Map<String, MaterializedViewMetadata> map2 = this.buildViews(keyspace, rows.views.get(keyspace.getName()), rows.columns.get(keyspace.getName()), cassandraVersion, cluster);
            aggregate2 = map2.values().iterator();
            while (aggregate2.hasNext()) {
                MaterializedViewMetadata view = (MaterializedViewMetadata)aggregate2.next();
                keyspace.add(view);
            }
            Row scyllaKeyspacesRow = rows.scyllaKeyspaces.getOrDefault(keyspace.getName(), null);
            if (scyllaKeyspacesRow != null && scyllaKeyspacesRow.getColumnDefinitions().contains("initial_tablets") && !scyllaKeyspacesRow.isNull("initial_tablets")) {
                keyspace.setUsesTablets(true);
            }
            keyspaces.put(keyspace.getName(), keyspace);
        }
        if (rows.virtualKeyspaces != null) {
            for (Row keyspaceRow : rows.virtualKeyspaces) {
                keyspace = KeyspaceMetadata.buildVirtual(keyspaceRow, cassandraVersion);
                Map<String, TableMetadata> tables = this.buildTables(keyspace, rows.virtualTables.get(keyspace.getName()), rows.virtualColumns.get(keyspace.getName()), Collections.emptyMap(), cassandraVersion, cluster);
                for (TableMetadata tableMetadata : tables.values()) {
                    keyspace.add(tableMetadata);
                }
                keyspaces.put(keyspace.getName(), keyspace);
            }
        }
        return keyspaces;
    }

    protected Map<String, TableMetadata> buildTables(KeyspaceMetadata keyspace, List<Row> tableRows, Map<String, Map<String, ColumnMetadata.Raw>> colsDefs, Map<String, List<Row>> indexDefs, VersionNumber cassandraVersion, Cluster cluster) {
        LinkedHashMap<String, TableMetadata> tables = new LinkedHashMap<String, TableMetadata>();
        if (tableRows != null) {
            for (Row tableDef : tableRows) {
                String cfName = tableDef.getString(this.tableNameColumn());
                try {
                    Map<String, ColumnMetadata.Raw> cols;
                    Map<String, ColumnMetadata.Raw> map = cols = colsDefs == null ? null : colsDefs.get(cfName);
                    if (cols == null || cols.isEmpty()) {
                        if (cassandraVersion.getMajor() >= 2) continue;
                        cols = Collections.emptyMap();
                    }
                    List<Row> cfIndexes = indexDefs == null ? null : indexDefs.get(cfName);
                    TableMetadata table = TableMetadata.build(keyspace, tableDef, cols, cfIndexes, this.tableNameColumn(), cassandraVersion, cluster);
                    tables.put(table.getName(), table);
                }
                catch (RuntimeException e) {
                    logger.error(String.format("Error parsing schema for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\") will be missing or incomplete", keyspace.getName(), cfName, keyspace.getName(), cfName), (Throwable)e);
                }
            }
        }
        return tables;
    }

    protected Map<String, UserType> buildUserTypes(KeyspaceMetadata keyspace, List<Row> udtRows, VersionNumber cassandraVersion, Cluster cluster) {
        LinkedHashMap<String, UserType> userTypes = new LinkedHashMap<String, UserType>();
        if (udtRows != null) {
            for (Row udtRow : this.maybeSortUdts(udtRows, cluster, keyspace.getName())) {
                UserType type = UserType.build(keyspace, udtRow, cassandraVersion, cluster, userTypes);
                userTypes.put(type.getTypeName(), type);
            }
        }
        return userTypes;
    }

    protected List<Row> maybeSortUdts(List<Row> udtRows, Cluster cluster, String keyspace) {
        return udtRows;
    }

    protected Map<String, FunctionMetadata> buildFunctions(KeyspaceMetadata keyspace, List<Row> functionRows, VersionNumber cassandraVersion, Cluster cluster) {
        LinkedHashMap<String, FunctionMetadata> functions = new LinkedHashMap<String, FunctionMetadata>();
        if (functionRows != null) {
            for (Row functionRow : functionRows) {
                FunctionMetadata function = FunctionMetadata.build(keyspace, functionRow, cassandraVersion, cluster);
                if (function == null) continue;
                String name = Metadata.fullFunctionName(function.getSimpleName(), function.getArguments().values());
                functions.put(name, function);
            }
        }
        return functions;
    }

    protected Map<String, AggregateMetadata> buildAggregates(KeyspaceMetadata keyspace, List<Row> aggregateRows, VersionNumber cassandraVersion, Cluster cluster) {
        LinkedHashMap<String, AggregateMetadata> aggregates = new LinkedHashMap<String, AggregateMetadata>();
        if (aggregateRows != null) {
            for (Row aggregateRow : aggregateRows) {
                AggregateMetadata aggregate = AggregateMetadata.build(keyspace, aggregateRow, cassandraVersion, cluster);
                if (aggregate == null) continue;
                String name = Metadata.fullFunctionName(aggregate.getSimpleName(), aggregate.getArgumentTypes());
                aggregates.put(name, aggregate);
            }
        }
        return aggregates;
    }

    protected Map<String, MaterializedViewMetadata> buildViews(KeyspaceMetadata keyspace, List<Row> viewRows, Map<String, Map<String, ColumnMetadata.Raw>> colsDefs, VersionNumber cassandraVersion, Cluster cluster) {
        LinkedHashMap<String, MaterializedViewMetadata> views = new LinkedHashMap<String, MaterializedViewMetadata>();
        if (viewRows != null) {
            for (Row viewRow : viewRows) {
                String viewName = viewRow.getString("view_name");
                try {
                    MaterializedViewMetadata view;
                    Map<String, ColumnMetadata.Raw> cols = colsDefs.get(viewName);
                    if (cols == null || cols.isEmpty() || (view = MaterializedViewMetadata.build(keyspace, viewRow, cols, cassandraVersion, cluster)) == null) continue;
                    views.put(view.getName(), view);
                }
                catch (RuntimeException e) {
                    logger.error(String.format("Error parsing schema for view %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getView(\"%s\") will be missing or incomplete", keyspace.getName(), viewName, keyspace.getName(), viewName), (Throwable)e);
                }
            }
        }
        return views;
    }

    protected void updateKeyspaces(Metadata metadata, Map<String, KeyspaceMetadata> oldKeyspaces, Map<String, KeyspaceMetadata> newKeyspaces, String keyspaceToRebuild) {
        Iterator<KeyspaceMetadata> it = oldKeyspaces.values().iterator();
        while (it.hasNext()) {
            KeyspaceMetadata oldKeyspace = it.next();
            String keyspaceName = oldKeyspace.getName();
            if (keyspaceToRebuild != null && !keyspaceToRebuild.equals(keyspaceName) || newKeyspaces.containsKey(keyspaceName)) continue;
            it.remove();
            metadata.triggerOnKeyspaceRemoved(oldKeyspace);
        }
        for (KeyspaceMetadata newKeyspace : newKeyspaces.values()) {
            KeyspaceMetadata oldKeyspace = oldKeyspaces.put(newKeyspace.getName(), newKeyspace);
            if (oldKeyspace == null) {
                metadata.triggerOnKeyspaceAdded(newKeyspace);
            } else if (!oldKeyspace.equals(newKeyspace)) {
                metadata.triggerOnKeyspaceChanged(newKeyspace, oldKeyspace);
            }
            HashMap<String, TableMetadata> oldTables = oldKeyspace == null ? new HashMap<String, TableMetadata>() : new HashMap<String, TableMetadata>(oldKeyspace.tables);
            this.updateTables(metadata, oldTables, newKeyspace.tables, null);
            HashMap<String, UserType> oldTypes = oldKeyspace == null ? new HashMap<String, UserType>() : new HashMap<String, UserType>(oldKeyspace.userTypes);
            this.updateUserTypes(metadata, oldTypes, newKeyspace.userTypes, null);
            HashMap<String, FunctionMetadata> oldFunctions = oldKeyspace == null ? new HashMap<String, FunctionMetadata>() : new HashMap<String, FunctionMetadata>(oldKeyspace.functions);
            this.updateFunctions(metadata, oldFunctions, newKeyspace.functions, null);
            HashMap<String, AggregateMetadata> oldAggregates = oldKeyspace == null ? new HashMap<String, AggregateMetadata>() : new HashMap<String, AggregateMetadata>(oldKeyspace.aggregates);
            this.updateAggregates(metadata, oldAggregates, newKeyspace.aggregates, null);
            HashMap<String, MaterializedViewMetadata> oldViews = oldKeyspace == null ? new HashMap<String, MaterializedViewMetadata>() : new HashMap<String, MaterializedViewMetadata>(oldKeyspace.views);
            this.updateViews(metadata, oldViews, newKeyspace.views, null);
        }
    }

    private void updateTables(Metadata metadata, Map<String, TableMetadata> oldTables, Map<String, TableMetadata> newTables, String tableToRebuild) {
        Iterator<TableMetadata> it = oldTables.values().iterator();
        while (it.hasNext()) {
            TableMetadata oldTable = it.next();
            String tableName = oldTable.getName();
            if (tableToRebuild != null && !tableToRebuild.equals(tableName) || newTables.containsKey(tableName)) continue;
            it.remove();
            metadata.triggerOnTableRemoved(oldTable);
        }
        for (TableMetadata newTable : newTables.values()) {
            TableMetadata oldTable = oldTables.put(newTable.getName(), newTable);
            if (oldTable == null) {
                metadata.triggerOnTableAdded(newTable);
                continue;
            }
            if (tableToRebuild != null) {
                for (MaterializedViewMetadata view : oldTable.getViews()) {
                    view.setBaseTable(newTable);
                }
            }
            if (oldTable.equals(newTable)) continue;
            metadata.triggerOnTableChanged(newTable, oldTable);
        }
    }

    private void updateUserTypes(Metadata metadata, Map<String, UserType> oldTypes, Map<String, UserType> newTypes, String typeToRebuild) {
        Iterator<UserType> it = oldTypes.values().iterator();
        while (it.hasNext()) {
            UserType oldType = it.next();
            String typeName = oldType.getTypeName();
            if (typeToRebuild != null && !typeToRebuild.equals(typeName) || newTypes.containsKey(typeName)) continue;
            it.remove();
            metadata.triggerOnUserTypeRemoved(oldType);
        }
        for (UserType newType : newTypes.values()) {
            UserType oldType = oldTypes.put(newType.getTypeName(), newType);
            if (oldType == null) {
                metadata.triggerOnUserTypeAdded(newType);
                continue;
            }
            if (newType.equals(oldType)) continue;
            metadata.triggerOnUserTypeChanged(newType, oldType);
        }
    }

    private void updateFunctions(Metadata metadata, Map<String, FunctionMetadata> oldFunctions, Map<String, FunctionMetadata> newFunctions, String functionToRebuild) {
        Iterator<FunctionMetadata> it = oldFunctions.values().iterator();
        while (it.hasNext()) {
            FunctionMetadata oldFunction = it.next();
            String oldFunctionName = Metadata.fullFunctionName(oldFunction.getSimpleName(), oldFunction.getArguments().values());
            if (functionToRebuild != null && !functionToRebuild.equals(oldFunctionName) || newFunctions.containsKey(oldFunctionName)) continue;
            it.remove();
            metadata.triggerOnFunctionRemoved(oldFunction);
        }
        for (FunctionMetadata newFunction : newFunctions.values()) {
            String newFunctionName = Metadata.fullFunctionName(newFunction.getSimpleName(), newFunction.getArguments().values());
            FunctionMetadata oldFunction = oldFunctions.put(newFunctionName, newFunction);
            if (oldFunction == null) {
                metadata.triggerOnFunctionAdded(newFunction);
                continue;
            }
            if (newFunction.equals(oldFunction)) continue;
            metadata.triggerOnFunctionChanged(newFunction, oldFunction);
        }
    }

    private void updateAggregates(Metadata metadata, Map<String, AggregateMetadata> oldAggregates, Map<String, AggregateMetadata> newAggregates, String aggregateToRebuild) {
        Iterator<AggregateMetadata> it = oldAggregates.values().iterator();
        while (it.hasNext()) {
            AggregateMetadata oldAggregate = it.next();
            String oldAggregateName = Metadata.fullFunctionName(oldAggregate.getSimpleName(), oldAggregate.getArgumentTypes());
            if (aggregateToRebuild != null && !aggregateToRebuild.equals(oldAggregateName) || newAggregates.containsKey(oldAggregateName)) continue;
            it.remove();
            metadata.triggerOnAggregateRemoved(oldAggregate);
        }
        for (AggregateMetadata newAggregate : newAggregates.values()) {
            String newAggregateName = Metadata.fullFunctionName(newAggregate.getSimpleName(), newAggregate.getArgumentTypes());
            AggregateMetadata oldAggregate = oldAggregates.put(newAggregateName, newAggregate);
            if (oldAggregate == null) {
                metadata.triggerOnAggregateAdded(newAggregate);
                continue;
            }
            if (newAggregate.equals(oldAggregate)) continue;
            metadata.triggerOnAggregateChanged(newAggregate, oldAggregate);
        }
    }

    private void updateViews(Metadata metadata, Map<String, MaterializedViewMetadata> oldViews, Map<String, MaterializedViewMetadata> newViews, String viewToRebuild) {
        Iterator<MaterializedViewMetadata> it = oldViews.values().iterator();
        while (it.hasNext()) {
            MaterializedViewMetadata oldView = it.next();
            String aggregateName = oldView.getName();
            if (viewToRebuild != null && !viewToRebuild.equals(aggregateName) || newViews.containsKey(aggregateName)) continue;
            it.remove();
            metadata.triggerOnMaterializedViewRemoved(oldView);
        }
        for (MaterializedViewMetadata newView : newViews.values()) {
            MaterializedViewMetadata oldView = oldViews.put(newView.getName(), newView);
            if (oldView == null) {
                metadata.triggerOnMaterializedViewAdded(newView);
                continue;
            }
            if (newView.equals(oldView)) continue;
            metadata.triggerOnMaterializedViewChanged(newView, oldView);
        }
    }

    static Set<String> toKeyspaceSet(ResultSet rs) {
        if (rs == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Row row : rs) {
            result.add(row.getString("keyspace_name"));
        }
        return result;
    }

    static Map<String, Row> groupByKeyspacePk(ResultSet rs) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Row> result = new HashMap<String, Row>();
        for (Row row : rs) {
            String ksName = row.getString("keyspace_name");
            result.put(ksName, row);
        }
        return result;
    }

    static Map<String, List<Row>> groupByKeyspace(ResultSet rs) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Row>> result = new HashMap<String, List<Row>>();
        for (Row row : rs) {
            String ksName = row.getString("keyspace_name");
            ArrayList<Row> l = (ArrayList<Row>)result.get(ksName);
            if (l == null) {
                l = new ArrayList<Row>();
                result.put(ksName, l);
            }
            l.add(row);
        }
        return result;
    }

    static Map<String, Map<String, List<Row>>> groupByKeyspaceAndCf(ResultSet rs, String tableName) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, List<Row>>> result = Maps.newHashMap();
        for (Row row : rs) {
            ArrayList<Row> l;
            String ksName = row.getString("keyspace_name");
            String cfName = row.getString(tableName);
            HashMap rowsByCf = (HashMap)result.get(ksName);
            if (rowsByCf == null) {
                rowsByCf = Maps.newHashMap();
                result.put(ksName, rowsByCf);
            }
            if ((l = (ArrayList<Row>)rowsByCf.get(cfName)) == null) {
                l = Lists.newArrayList();
                rowsByCf.put(cfName, l);
            }
            l.add(row);
        }
        return result;
    }

    static Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> groupByKeyspaceAndCf(ResultSet rs, VersionNumber cassandraVersion, String tableName) {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>> result = new HashMap<String, Map<String, Map<String, ColumnMetadata.Raw>>>();
        for (Row row : rs) {
            HashMap<String, ColumnMetadata.Raw> l;
            String ksName = row.getString("keyspace_name");
            String cfName = row.getString(tableName);
            HashMap colsByCf = (HashMap)result.get(ksName);
            if (colsByCf == null) {
                colsByCf = new HashMap();
                result.put(ksName, colsByCf);
            }
            if ((l = (HashMap<String, ColumnMetadata.Raw>)colsByCf.get(cfName)) == null) {
                l = new HashMap<String, ColumnMetadata.Raw>();
                colsByCf.put(cfName, l);
            }
            ColumnMetadata.Raw c = ColumnMetadata.Raw.fromRow(row, cassandraVersion);
            l.put(c.name, c);
        }
        return result;
    }

    private static ResultSetFuture queryAsync(String query, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException {
        DefaultResultSetFuture future = new DefaultResultSetFuture(null, protocolVersion, new Requests.Query(query));
        connection.write(future);
        return future;
    }

    private static ResultSet get(ResultSetFuture future) throws InterruptedException, ExecutionException {
        return future == null ? null : (ResultSet)future.get();
    }

    private static ResultSet getIfExists(ResultSetFuture future) throws InterruptedException, ExecutionException {
        if (future == null) {
            return null;
        }
        try {
            ResultSet resultSet = (ResultSet)future.get();
            return resultSet;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof InvalidQueryException) {
                return null;
            }
            throw ex;
        }
    }

    private static class V4SchemaParser
    extends V3SchemaParser {
        private static final String SELECT_VIRTUAL_KEYSPACES = "SELECT * FROM system_virtual_schema.keyspaces";
        private static final String SELECT_VIRTUAL_TABLES = "SELECT * FROM system_virtual_schema.tables";
        private static final String SELECT_VIRTUAL_COLUMNS = "SELECT * FROM system_virtual_schema.columns";
        private static final String TABLE_NAME = "table_name";

        private V4SchemaParser() {
        }

        @Override
        SystemRows fetchSystemRows(Cluster cluster, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            boolean isSchemaOrKeyspace = targetType == null || targetType == SchemaElement.KEYSPACE;
            ResultSetFuture ksFuture = null;
            ResultSetFuture udtFuture = null;
            ResultSetFuture cfFuture = null;
            ResultSetFuture colsFuture = null;
            ResultSetFuture functionsFuture = null;
            ResultSetFuture aggregatesFuture = null;
            ResultSetFuture indexesFuture = null;
            ResultSetFuture viewsFuture = null;
            ResultSetFuture virtualKeyspacesFuture = null;
            ResultSetFuture virtualTableFuture = null;
            ResultSetFuture virtualColumnsFuture = null;
            ResultSetFuture scyllaKsFuture = null;
            ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
            if (isSchemaOrKeyspace) {
                ksFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.keyspaces" + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                virtualKeyspacesFuture = SchemaParser.queryAsync(SELECT_VIRTUAL_KEYSPACES + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                virtualColumnsFuture = SchemaParser.queryAsync(SELECT_VIRTUAL_COLUMNS + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                virtualTableFuture = SchemaParser.queryAsync(SELECT_VIRTUAL_TABLES + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TYPE) {
                udtFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.types" + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TABLE) {
                cfFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.tables" + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                colsFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.columns" + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                indexesFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.indexes" + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                viewsFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.views" + V4SchemaParser.whereClause(targetType == SchemaElement.TABLE ? SchemaElement.VIEW : targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.FUNCTION) {
                functionsFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.functions" + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.AGGREGATE) {
                aggregatesFuture = SchemaParser.queryAsync("SELECT * FROM system_schema.aggregates" + V4SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace) {
                scyllaKsFuture = targetType == SchemaElement.KEYSPACE ? SchemaParser.queryAsync("SELECT * FROM system_schema.scylla_keyspaces WHERE keyspace_name = '" + targetKeyspace + "' LIMIT 1;", connection, protocolVersion) : SchemaParser.queryAsync(SchemaParser.SELECT_SCYLLA_KEYSPACES, connection, protocolVersion);
            }
            return new SystemRows(SchemaParser.get(ksFuture), V4SchemaParser.groupByKeyspace(SchemaParser.get(cfFuture)), V4SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(colsFuture), cassandraVersion, TABLE_NAME), V4SchemaParser.groupByKeyspace(SchemaParser.get(udtFuture)), V4SchemaParser.groupByKeyspace(SchemaParser.get(functionsFuture)), V4SchemaParser.groupByKeyspace(SchemaParser.get(aggregatesFuture)), V4SchemaParser.groupByKeyspace(SchemaParser.get(viewsFuture)), V4SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(indexesFuture), TABLE_NAME), SchemaParser.get(virtualKeyspacesFuture), V4SchemaParser.groupByKeyspace(SchemaParser.get(virtualTableFuture)), V4SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(virtualColumnsFuture), cassandraVersion, TABLE_NAME), V4SchemaParser.groupByKeyspacePk(SchemaParser.getIfExists(scyllaKsFuture)));
        }
    }

    private static class V3SchemaParser
    extends SchemaParser {
        protected static final String SELECT_KEYSPACES = "SELECT * FROM system_schema.keyspaces";
        protected static final String SELECT_TABLES = "SELECT * FROM system_schema.tables";
        protected static final String SELECT_COLUMNS = "SELECT * FROM system_schema.columns";
        protected static final String SELECT_USERTYPES = "SELECT * FROM system_schema.types";
        protected static final String SELECT_FUNCTIONS = "SELECT * FROM system_schema.functions";
        protected static final String SELECT_AGGREGATES = "SELECT * FROM system_schema.aggregates";
        protected static final String SELECT_INDEXES = "SELECT * FROM system_schema.indexes";
        protected static final String SELECT_VIEWS = "SELECT * FROM system_schema.views";
        private static final String TABLE_NAME = "table_name";
        private static final String VIEW_NAME = "view_name";
        private static final String COLUMN_NAME = "column_name";
        private static final String INDEX_NAME = "index_name";
        private static final String FUNCTION_NAME = "function_name";
        private static final String ARGUMENT_TYPES = "argument_types";
        private static final String AGGREGATE_NAME = "aggregate_name";
        private static final String TYPE_NAME = "type_name";
        private static final String LIMIT = " LIMIT 1000";
        private static final Comparator<Row> sortByTypeName = new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                String type1 = o1.getString(V3SchemaParser.TYPE_NAME);
                String type2 = o2.getString(V3SchemaParser.TYPE_NAME);
                if (type1 == null && type2 == null) {
                    return 0;
                }
                if (type2 == null) {
                    return 1;
                }
                if (type1 == null) {
                    return -1;
                }
                return type1.compareTo(type2);
            }
        };

        private V3SchemaParser() {
        }

        private List<Row> fetchUDTs(KeyspaceMetadata keyspace, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            String queryPrefix = SELECT_USERTYPES + V3SchemaParser.whereClause(SchemaElement.KEYSPACE, keyspace.getName(), null, null);
            ArrayList<Row> result = new ArrayList<Row>();
            List rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + LIMIT, connection, protocolVersion).get()).all();
            while (!rs.isEmpty()) {
                result.addAll(rs);
                String lastSeen = "'" + ((Row)result.get(result.size() - 1)).getString(TYPE_NAME) + "'";
                rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + " AND " + TYPE_NAME + " > " + lastSeen + LIMIT, connection, protocolVersion).get()).all();
            }
            return result;
        }

        private void buildUDTs(KeyspaceMetadata keyspace, Cluster cluster, Connection connection, VersionNumber cassandraVersion, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            List<Row> raw = this.fetchUDTs(keyspace, connection, protocolVersion);
            Map<String, UserType> userTypes = this.buildUserTypes(keyspace, raw, cassandraVersion, cluster);
            for (UserType userType : userTypes.values()) {
                keyspace.add(userType);
            }
        }

        private List<Row> fetchFunctions(KeyspaceMetadata keyspace, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            String queryPrefix = SELECT_FUNCTIONS + V3SchemaParser.whereClause(SchemaElement.KEYSPACE, keyspace.getName(), null, null);
            ArrayList<Row> result = new ArrayList<Row>();
            List rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + LIMIT, connection, protocolVersion).get()).all();
            while (!rs.isEmpty()) {
                String lastSeenFunction = "'" + ((Row)rs.get(rs.size() - 1)).getString(FUNCTION_NAME) + "'";
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                boolean first = true;
                for (String arg_type : ((Row)rs.get(rs.size() - 1)).getList(ARGUMENT_TYPES, String.class)) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("'").append(arg_type).append("'");
                }
                sb.append("]");
                String lastSeenArgs = sb.toString();
                result.addAll(rs);
                rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + " AND (" + FUNCTION_NAME + ", " + ARGUMENT_TYPES + ") > (" + lastSeenFunction + ", " + lastSeenArgs + ")" + LIMIT, connection, protocolVersion).get()).all();
            }
            return result;
        }

        private void buildFunctions(KeyspaceMetadata keyspace, Cluster cluster, Connection connection, VersionNumber cassandraVersion, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            List<Row> raw = this.fetchFunctions(keyspace, connection, protocolVersion);
            Map<String, FunctionMetadata> functions = this.buildFunctions(keyspace, raw, cassandraVersion, cluster);
            for (FunctionMetadata function : functions.values()) {
                keyspace.add(function);
            }
        }

        private List<Row> fetchAggregates(KeyspaceMetadata keyspace, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            String queryPrefix = SELECT_AGGREGATES + V3SchemaParser.whereClause(SchemaElement.KEYSPACE, keyspace.getName(), null, null);
            ArrayList<Row> result = new ArrayList<Row>();
            List rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + LIMIT, connection, protocolVersion).get()).all();
            while (!rs.isEmpty()) {
                String lastSeenAggregate = "'" + ((Row)rs.get(rs.size() - 1)).getString(AGGREGATE_NAME) + "'";
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                boolean first = true;
                for (String arg_type : ((Row)rs.get(rs.size() - 1)).getList(ARGUMENT_TYPES, String.class)) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("'").append(arg_type).append("'");
                }
                sb.append("]");
                String lastSeenArgs = sb.toString();
                result.addAll(rs);
                rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + " AND (" + AGGREGATE_NAME + ", " + ARGUMENT_TYPES + ") > (" + lastSeenAggregate + ", " + lastSeenArgs + ")" + LIMIT, connection, protocolVersion).get()).all();
            }
            return result;
        }

        private void buildAggregates(KeyspaceMetadata keyspace, Cluster cluster, Connection connection, VersionNumber cassandraVersion, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            List<Row> raw = this.fetchAggregates(keyspace, connection, protocolVersion);
            Map<String, AggregateMetadata> aggregates = this.buildAggregates(keyspace, raw, cassandraVersion, cluster);
            for (AggregateMetadata aggregate : aggregates.values()) {
                keyspace.add(aggregate);
            }
        }

        private Map<String, Map<String, Row>> fetchColumns(KeyspaceMetadata keyspace, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            String queryPrefix = SELECT_COLUMNS + V3SchemaParser.whereClause(SchemaElement.KEYSPACE, keyspace.getName(), null, null);
            HashMap<String, Map<String, Row>> result = new HashMap<String, Map<String, Row>>();
            List rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + LIMIT, connection, protocolVersion).get()).all();
            while (!rs.isEmpty()) {
                String lastSeenTable = "'" + ((Row)rs.get(rs.size() - 1)).getString(TABLE_NAME) + "'";
                String lastSeenColumn = "'" + ((Row)rs.get(rs.size() - 1)).getString(COLUMN_NAME) + "'";
                for (Row row : rs) {
                    String cfName = row.getString(TABLE_NAME);
                    HashMap<String, Row> colsByCf = (HashMap<String, Row>)result.get(cfName);
                    if (colsByCf == null) {
                        colsByCf = new HashMap<String, Row>();
                        result.put(cfName, colsByCf);
                    }
                    colsByCf.put(row.getString(COLUMN_NAME), row);
                }
                rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + " AND (" + TABLE_NAME + ", " + COLUMN_NAME + ") > (" + lastSeenTable + ", " + lastSeenColumn + ")" + LIMIT, connection, protocolVersion).get()).all();
            }
            return result;
        }

        private Map<String, Map<String, ColumnMetadata.Raw>> buildColumns(KeyspaceMetadata keyspace, Connection connection, VersionNumber cassandraVersion, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            Map<String, Map<String, Row>> raw = this.fetchColumns(keyspace, connection, protocolVersion);
            HashMap<String, Map<String, ColumnMetadata.Raw>> result = new HashMap<String, Map<String, ColumnMetadata.Raw>>();
            for (Map.Entry<String, Map<String, Row>> table : raw.entrySet()) {
                HashMap<String, ColumnMetadata.Raw> columns = new HashMap<String, ColumnMetadata.Raw>();
                for (Map.Entry<String, Row> column : table.getValue().entrySet()) {
                    columns.put(column.getKey(), ColumnMetadata.Raw.fromRow(column.getValue(), cassandraVersion));
                }
                result.put(table.getKey(), columns);
            }
            return result;
        }

        private List<Row> fetchTables(KeyspaceMetadata keyspace, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            String queryPrefix = SELECT_TABLES + V3SchemaParser.whereClause(SchemaElement.KEYSPACE, keyspace.getName(), null, null);
            ArrayList<Row> result = new ArrayList<Row>();
            List rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + LIMIT, connection, protocolVersion).get()).all();
            while (!rs.isEmpty()) {
                result.addAll(rs);
                String lastSeen = "'" + ((Row)result.get(result.size() - 1)).getString(TABLE_NAME) + "'";
                rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + " AND " + TABLE_NAME + " > " + lastSeen + LIMIT, connection, protocolVersion).get()).all();
            }
            return result;
        }

        private Map<String, List<Row>> fetchIndexes(KeyspaceMetadata keyspace, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            String queryPrefix = SELECT_INDEXES + V3SchemaParser.whereClause(SchemaElement.KEYSPACE, keyspace.getName(), null, null);
            HashMap<String, List<Row>> result = Maps.newHashMap();
            List rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + LIMIT, connection, protocolVersion).get()).all();
            while (!rs.isEmpty()) {
                String lastSeenTable = "'" + ((Row)rs.get(rs.size() - 1)).getString(TABLE_NAME) + "'";
                String lastSeenIndex = "'" + ((Row)rs.get(rs.size() - 1)).getString(INDEX_NAME) + "'";
                for (Row row : rs) {
                    String cfName = row.getString(TABLE_NAME);
                    ArrayList<Row> rowsByCf = (ArrayList<Row>)result.get(cfName);
                    if (rowsByCf == null) {
                        rowsByCf = Lists.newArrayList();
                        result.put(cfName, rowsByCf);
                    }
                    rowsByCf.add(row);
                }
                rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + " AND (" + TABLE_NAME + ", " + INDEX_NAME + ") > (" + lastSeenTable + ", " + lastSeenIndex + ")" + LIMIT, connection, protocolVersion).get()).all();
            }
            return result;
        }

        private List<Row> fetchViews(KeyspaceMetadata keyspace, Connection connection, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            String queryPrefix = SELECT_VIEWS + V3SchemaParser.whereClause(SchemaElement.KEYSPACE, keyspace.getName(), null, null);
            ArrayList<Row> result = new ArrayList<Row>();
            List rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + LIMIT, connection, protocolVersion).get()).all();
            while (!rs.isEmpty()) {
                result.addAll(rs);
                String lastSeen = "'" + ((Row)result.get(result.size() - 1)).getString(VIEW_NAME) + "'";
                rs = ((ResultSet)SchemaParser.queryAsync(queryPrefix + " AND " + VIEW_NAME + " > " + lastSeen + LIMIT, connection, protocolVersion).get()).all();
            }
            return result;
        }

        private void buildTablesIndexesAndViews(KeyspaceMetadata keyspace, Cluster cluster, Connection connection, VersionNumber cassandraVersion, ProtocolVersion protocolVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            List<Row> cf = this.fetchTables(keyspace, connection, protocolVersion);
            Map<String, Map<String, ColumnMetadata.Raw>> columns = this.buildColumns(keyspace, connection, cassandraVersion, protocolVersion);
            Map<String, List<Row>> indexes = this.fetchIndexes(keyspace, connection, protocolVersion);
            Map<String, TableMetadata> tables = this.buildTables(keyspace, cf, columns, indexes, cassandraVersion, cluster);
            for (TableMetadata table : tables.values()) {
                keyspace.add(table);
            }
            List<Row> viewsData = this.fetchViews(keyspace, connection, protocolVersion);
            Map<String, MaterializedViewMetadata> views = this.buildViews(keyspace, viewsData, columns, cassandraVersion, cluster);
            for (MaterializedViewMetadata view : views.values()) {
                keyspace.add(view);
            }
        }

        private Map<String, KeyspaceMetadata> buildSchema(Cluster cluster, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, InterruptedException, ExecutionException {
            ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
            LinkedHashMap<String, KeyspaceMetadata> keyspaces = new LinkedHashMap<String, KeyspaceMetadata>();
            ResultSetFuture scyllaKeyspacesFuture = SchemaParser.queryAsync(SchemaParser.SELECT_SCYLLA_KEYSPACES, connection, protocolVersion);
            ResultSet keyspacesData = (ResultSet)SchemaParser.queryAsync(SELECT_KEYSPACES, connection, protocolVersion).get();
            Map<String, Row> scyllaKeyspacesData = V3SchemaParser.groupByKeyspacePk(SchemaParser.getIfExists(scyllaKeyspacesFuture));
            for (Row row : keyspacesData) {
                KeyspaceMetadata keyspace = KeyspaceMetadata.build(row, cassandraVersion);
                Row scyllaKeyspacesRow = scyllaKeyspacesData.getOrDefault(keyspace.getName(), null);
                if (scyllaKeyspacesRow != null && scyllaKeyspacesRow.getColumnDefinitions().contains("initial_tablets") && !scyllaKeyspacesRow.isNull("initial_tablets")) {
                    keyspace.setUsesTablets(true);
                }
                keyspaces.put(keyspace.getName(), keyspace);
            }
            for (Map.Entry entry : keyspaces.entrySet()) {
                this.buildUDTs((KeyspaceMetadata)entry.getValue(), cluster, connection, cassandraVersion, protocolVersion);
                this.buildFunctions((KeyspaceMetadata)entry.getValue(), cluster, connection, cassandraVersion, protocolVersion);
                this.buildAggregates((KeyspaceMetadata)entry.getValue(), cluster, connection, cassandraVersion, protocolVersion);
                this.buildTablesIndexesAndViews((KeyspaceMetadata)entry.getValue(), cluster, connection, cassandraVersion, protocolVersion);
            }
            return keyspaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void refresh(Cluster cluster, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            if (targetType == null && cluster.getConfiguration().getQueryOptions().isSchemaQueriesPaged()) {
                Metadata metadata;
                Map<String, KeyspaceMetadata> keyspaces = this.buildSchema(cluster, connection, cassandraVersion);
                try {
                    metadata = cluster.getMetadata();
                }
                catch (IllegalStateException e) {
                    logger.warn("Unable to refresh metadata, cluster has been closed");
                    return;
                }
                metadata.lock.lock();
                try {
                    this.updateKeyspaces(metadata, metadata.keyspaces, keyspaces, null);
                    metadata.rebuildTokenMap();
                }
                catch (RuntimeException e) {
                    logger.error("Error parsing schema from Cassandra system tables: the schema in Cluster#getMetadata() will appear incomplete or stale", (Throwable)e);
                }
                finally {
                    metadata.lock.unlock();
                }
            } else {
                super.refresh(cluster, targetType, targetKeyspace, targetName, targetSignature, connection, cassandraVersion);
            }
        }

        @Override
        SystemRows fetchSystemRows(Cluster cluster, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            boolean isSchemaOrKeyspace = targetType == null || targetType == SchemaElement.KEYSPACE;
            ResultSetFuture ksFuture = null;
            ResultSetFuture udtFuture = null;
            ResultSetFuture cfFuture = null;
            ResultSetFuture colsFuture = null;
            ResultSetFuture functionsFuture = null;
            ResultSetFuture aggregatesFuture = null;
            ResultSetFuture indexesFuture = null;
            ResultSetFuture viewsFuture = null;
            ResultSetFuture scyllaKsFuture = null;
            ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
            if (isSchemaOrKeyspace) {
                ksFuture = SchemaParser.queryAsync(SELECT_KEYSPACES + V3SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TYPE) {
                udtFuture = SchemaParser.queryAsync(SELECT_USERTYPES + V3SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TABLE) {
                cfFuture = SchemaParser.queryAsync(SELECT_TABLES + V3SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                colsFuture = SchemaParser.queryAsync(SELECT_COLUMNS + V3SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                indexesFuture = SchemaParser.queryAsync(SELECT_INDEXES + V3SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
                viewsFuture = SchemaParser.queryAsync(SELECT_VIEWS + V3SchemaParser.whereClause(targetType == SchemaElement.TABLE ? SchemaElement.VIEW : targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.FUNCTION) {
                functionsFuture = SchemaParser.queryAsync(SELECT_FUNCTIONS + V3SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.AGGREGATE) {
                aggregatesFuture = SchemaParser.queryAsync(SELECT_AGGREGATES + V3SchemaParser.whereClause(targetType, targetKeyspace, targetName, targetSignature), connection, protocolVersion);
            }
            if (isSchemaOrKeyspace) {
                scyllaKsFuture = targetType == SchemaElement.KEYSPACE ? SchemaParser.queryAsync("SELECT * FROM system_schema.scylla_keyspaces WHERE keyspace_name = '" + targetKeyspace + "' LIMIT 1;", connection, protocolVersion) : SchemaParser.queryAsync(SchemaParser.SELECT_SCYLLA_KEYSPACES, connection, protocolVersion);
            }
            return new SystemRows(SchemaParser.get(ksFuture), V3SchemaParser.groupByKeyspace(SchemaParser.get(cfFuture)), V3SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(colsFuture), cassandraVersion, TABLE_NAME), V3SchemaParser.groupByKeyspace(SchemaParser.get(udtFuture)), V3SchemaParser.groupByKeyspace(SchemaParser.get(functionsFuture)), V3SchemaParser.groupByKeyspace(SchemaParser.get(aggregatesFuture)), V3SchemaParser.groupByKeyspace(SchemaParser.get(viewsFuture)), V3SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(indexesFuture), TABLE_NAME), null, Collections.emptyMap(), Collections.emptyMap(), V3SchemaParser.groupByKeyspacePk(SchemaParser.getIfExists(scyllaKsFuture)));
        }

        @Override
        String tableNameColumn() {
            return TABLE_NAME;
        }

        protected static String whereClause(SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
            String whereClause = "";
            if (targetType != null) {
                whereClause = " WHERE keyspace_name = '" + targetKeyspace + '\'';
                if (targetType == SchemaElement.TABLE) {
                    whereClause = whereClause + " AND table_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.VIEW) {
                    whereClause = whereClause + " AND view_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.TYPE) {
                    whereClause = whereClause + " AND type_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.FUNCTION) {
                    whereClause = whereClause + " AND function_name = '" + targetName + "' AND argument_types = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                } else if (targetType == SchemaElement.AGGREGATE) {
                    whereClause = whereClause + " AND aggregate_name = '" + targetName + "' AND argument_types = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                }
            }
            return whereClause;
        }

        @Override
        protected List<Row> maybeSortUdts(List<Row> udtRows, Cluster cluster, String keyspace) {
            if (udtRows.size() < 2) {
                return udtRows;
            }
            DirectedGraph<Row> graph = new DirectedGraph<Row>(sortByTypeName, udtRows);
            for (Row from : udtRows) {
                for (Row to : udtRows) {
                    if (from == to || !this.dependsOn(to, from, cluster, keyspace)) continue;
                    graph.addEdge(from, to);
                }
            }
            return graph.topologicalSort();
        }

        private boolean dependsOn(Row udt1, Row udt2, Cluster cluster, String keyspace) {
            List<String> fieldTypes = udt1.getList("field_types", String.class);
            String typeName = udt2.getString(TYPE_NAME);
            for (String fieldTypeStr : fieldTypes) {
                DataType fieldType = DataTypeCqlNameParser.parse(fieldTypeStr, cluster, keyspace, null, null, false, true);
                if (!this.references(fieldType, typeName)) continue;
                return true;
            }
            return false;
        }

        private boolean references(DataType dataType, String typeName) {
            if (dataType instanceof UserType.Shallow && ((UserType.Shallow)dataType).typeName.equals(typeName)) {
                return true;
            }
            for (DataType arg : dataType.getTypeArguments()) {
                if (!this.references(arg, typeName)) continue;
                return true;
            }
            if (dataType instanceof TupleType) {
                for (DataType arg : ((TupleType)dataType).getComponentTypes()) {
                    if (!this.references(arg, typeName)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class V2SchemaParser
    extends SchemaParser {
        private static final String SELECT_KEYSPACES = "SELECT * FROM system.schema_keyspaces";
        private static final String SELECT_COLUMN_FAMILIES = "SELECT * FROM system.schema_columnfamilies";
        private static final String SELECT_COLUMNS = "SELECT * FROM system.schema_columns";
        private static final String SELECT_USERTYPES = "SELECT * FROM system.schema_usertypes";
        private static final String SELECT_FUNCTIONS = "SELECT * FROM system.schema_functions";
        private static final String SELECT_AGGREGATES = "SELECT * FROM system.schema_aggregates";
        private static final String CF_NAME = "columnfamily_name";

        private V2SchemaParser() {
        }

        @Override
        SystemRows fetchSystemRows(Cluster cluster, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature, Connection connection, VersionNumber cassandraVersion) throws ConnectionException, BusyConnectionException, ExecutionException, InterruptedException {
            boolean isSchemaOrKeyspace = targetType == null || targetType == SchemaElement.KEYSPACE;
            String whereClause = "";
            if (targetType != null) {
                whereClause = " WHERE keyspace_name = '" + targetKeyspace + '\'';
                if (targetType == SchemaElement.TABLE) {
                    whereClause = whereClause + " AND columnfamily_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.TYPE) {
                    whereClause = whereClause + " AND type_name = '" + targetName + '\'';
                } else if (targetType == SchemaElement.FUNCTION) {
                    whereClause = whereClause + " AND function_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                } else if (targetType == SchemaElement.AGGREGATE) {
                    whereClause = whereClause + " AND aggregate_name = '" + targetName + "' AND signature = " + LIST_OF_TEXT_CODEC.format(targetSignature);
                }
            }
            ResultSetFuture ksFuture = null;
            ResultSetFuture udtFuture = null;
            ResultSetFuture cfFuture = null;
            ResultSetFuture colsFuture = null;
            ResultSetFuture functionsFuture = null;
            ResultSetFuture aggregatesFuture = null;
            ResultSetFuture scyllaKsFuture = null;
            ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
            if (isSchemaOrKeyspace) {
                ksFuture = SchemaParser.queryAsync(SELECT_KEYSPACES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdts(cassandraVersion) || targetType == SchemaElement.TYPE) {
                udtFuture = SchemaParser.queryAsync(SELECT_USERTYPES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace || targetType == SchemaElement.TABLE) {
                cfFuture = SchemaParser.queryAsync(SELECT_COLUMN_FAMILIES + whereClause, connection, protocolVersion);
                colsFuture = SchemaParser.queryAsync(SELECT_COLUMNS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdfs(cassandraVersion) || targetType == SchemaElement.FUNCTION) {
                functionsFuture = SchemaParser.queryAsync(SELECT_FUNCTIONS + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace && this.supportsUdfs(cassandraVersion) || targetType == SchemaElement.AGGREGATE) {
                aggregatesFuture = SchemaParser.queryAsync(SELECT_AGGREGATES + whereClause, connection, protocolVersion);
            }
            if (isSchemaOrKeyspace) {
                scyllaKsFuture = targetType == SchemaElement.KEYSPACE ? SchemaParser.queryAsync("SELECT * FROM system_schema.scylla_keyspaces WHERE keyspace_name = '" + targetKeyspace + "' LIMIT 1;", connection, protocolVersion) : SchemaParser.queryAsync(SchemaParser.SELECT_SCYLLA_KEYSPACES, connection, protocolVersion);
            }
            return new SystemRows(SchemaParser.get(ksFuture), V2SchemaParser.groupByKeyspace(SchemaParser.get(cfFuture)), V2SchemaParser.groupByKeyspaceAndCf(SchemaParser.get(colsFuture), cassandraVersion, CF_NAME), V2SchemaParser.groupByKeyspace(SchemaParser.get(udtFuture)), V2SchemaParser.groupByKeyspace(SchemaParser.get(functionsFuture)), V2SchemaParser.groupByKeyspace(SchemaParser.get(aggregatesFuture)), Collections.emptyMap(), Collections.emptyMap(), null, Collections.emptyMap(), Collections.emptyMap(), V2SchemaParser.groupByKeyspacePk(SchemaParser.getIfExists(scyllaKsFuture)));
        }

        @Override
        String tableNameColumn() {
            return CF_NAME;
        }

        private boolean supportsUdts(VersionNumber cassandraVersion) {
            return cassandraVersion.getMajor() > 2 || cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 1;
        }

        private boolean supportsUdfs(VersionNumber cassandraVersion) {
            return cassandraVersion.getMajor() > 2 || cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 2;
        }
    }

    private static class SystemRows {
        final ResultSet keyspaces;
        final Map<String, List<Row>> tables;
        final Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> columns;
        final Map<String, List<Row>> udts;
        final Map<String, List<Row>> functions;
        final Map<String, List<Row>> aggregates;
        final Map<String, List<Row>> views;
        final Map<String, Map<String, List<Row>>> indexes;
        final ResultSet virtualKeyspaces;
        final Map<String, List<Row>> virtualTables;
        final Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> virtualColumns;
        final Map<String, Row> scyllaKeyspaces;

        public SystemRows(ResultSet keyspaces, Map<String, List<Row>> tables, Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> columns, Map<String, List<Row>> udts, Map<String, List<Row>> functions, Map<String, List<Row>> aggregates, Map<String, List<Row>> views, Map<String, Map<String, List<Row>>> indexes, ResultSet virtualKeyspaces, Map<String, List<Row>> virtualTables, Map<String, Map<String, Map<String, ColumnMetadata.Raw>>> virtualColumns, Map<String, Row> scyllaKeyspaces) {
            this.keyspaces = keyspaces;
            this.tables = tables;
            this.columns = columns;
            this.udts = udts;
            this.functions = functions;
            this.aggregates = aggregates;
            this.views = views;
            this.indexes = indexes;
            this.virtualKeyspaces = virtualKeyspaces;
            this.virtualTables = virtualTables;
            this.virtualColumns = virtualColumns;
            this.scyllaKeyspaces = scyllaKeyspaces;
        }
    }
}

