/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;

class ScyllaCloudAuthInfo {
    private final byte[] clientCertificateData;
    private final String clientCertificatePath;
    private final byte[] clientKeyData;
    private final String clientKeyPath;
    private final String username;
    private final String password;

    @JsonCreator
    public ScyllaCloudAuthInfo(@JsonProperty(value="clientCertificateData") byte[] clientCertificateData, @JsonProperty(value="clientCertificatePath") String clientCertificatePath, @JsonProperty(value="clientKeyData") byte[] clientKeyData, @JsonProperty(value="clientKeyPath") String clientKeyPath, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        this.clientCertificateData = clientCertificateData;
        this.clientCertificatePath = clientCertificatePath;
        this.clientKeyData = clientKeyData;
        this.clientKeyPath = clientKeyPath;
        this.username = username;
        this.password = password;
    }

    public void validate() {
        File file;
        if (this.clientCertificateData == null) {
            if (this.clientCertificatePath == null) {
                throw new IllegalArgumentException("Either clientCertificateData or clientCertificatePath has to be provided for authInfo.");
            }
            file = new File(this.clientCertificatePath);
            if (!file.canRead()) {
                throw new IllegalArgumentException("Cannot read file at given clientCertificatePath (" + this.clientCertificatePath + ").");
            }
        }
        if (this.clientKeyData == null) {
            if (this.clientKeyPath == null) {
                throw new IllegalArgumentException("Either clientKeyData or clientKeyPath has to be provided for authInfo.");
            }
            file = new File(this.clientKeyPath);
            if (!file.canRead()) {
                throw new IllegalArgumentException("Cannot read file at given clientKeyPath (" + this.clientKeyPath + ").");
            }
        }
    }

    public byte[] getClientCertificateData() {
        return this.clientCertificateData;
    }

    public String getClientCertificatePath() {
        return this.clientCertificatePath;
    }

    public byte[] getClientKeyData() {
        return this.clientKeyData;
    }

    public String getClientKeyPath() {
        return this.clientKeyPath;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

