/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import shaded.com.scylladb.cdc.driver3.driver.core.ConfigurationBundle;
import shaded.com.scylladb.cdc.driver3.driver.core.Parameters;
import shaded.com.scylladb.cdc.driver3.driver.core.ScyllaCloudAuthInfo;
import shaded.com.scylladb.cdc.driver3.driver.core.ScyllaCloudContext;
import shaded.com.scylladb.cdc.driver3.driver.core.ScyllaCloudDatacenter;

class ScyllaCloudConnectionConfig {
    private final String kind;
    private final String apiVersion;
    private final Map<String, ScyllaCloudDatacenter> datacenters;
    private final Map<String, ScyllaCloudAuthInfo> authInfos;
    private final Map<String, ScyllaCloudContext> contexts;
    private final String currentContext;
    private final Parameters parameters;

    @JsonCreator
    public ScyllaCloudConnectionConfig(@JsonProperty(value="kind") String kind, @JsonProperty(value="apiVersion") String apiVersion, @JsonProperty(value="datacenters", required=true) Map<String, ScyllaCloudDatacenter> datacenters, @JsonProperty(value="authInfos", required=true) Map<String, ScyllaCloudAuthInfo> authInfos, @JsonProperty(value="contexts", required=true) Map<String, ScyllaCloudContext> contexts, @JsonProperty(value="currentContext", required=true) String currentContext, @JsonProperty(value="parameters") Parameters parameters) {
        this.kind = kind;
        this.apiVersion = apiVersion;
        this.datacenters = datacenters;
        this.authInfos = authInfos;
        this.contexts = contexts;
        this.currentContext = currentContext;
        this.parameters = parameters;
    }

    public static ScyllaCloudConnectionConfig fromInputStream(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        ScyllaCloudConnectionConfig scyllaCloudConnectionConfig = mapper.readValue(inputStream, ScyllaCloudConnectionConfig.class);
        scyllaCloudConnectionConfig.validate();
        return scyllaCloudConnectionConfig;
    }

    public void validate() {
        if (this.datacenters == null) {
            throw new IllegalArgumentException("Please provide datacenters (datacenters:) in the configuration yaml.");
        }
        for (ScyllaCloudDatacenter datacenter : this.datacenters.values()) {
            datacenter.validate();
        }
        if (this.authInfos == null) {
            throw new IllegalArgumentException("Please provide any authentication config (authInfos:) in the configuration yaml.");
        }
        for (ScyllaCloudAuthInfo authInfo : this.authInfos.values()) {
            authInfo.validate();
        }
        if (this.contexts == null) {
            throw new IllegalArgumentException("Please provide any configuration (contexts:) context in the configuration yaml.");
        }
        if (this.currentContext == null) {
            throw new IllegalArgumentException("Please set default context (currentContext:) in the configuration yaml.");
        }
    }

    public ConfigurationBundle createBundle() throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        InputStream certificateDataStream;
        this.validate();
        KeyStore identity = KeyStore.getInstance(KeyStore.getDefaultType());
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        identity.load(null, null);
        trustStore.load(null, null);
        for (Map.Entry<String, ScyllaCloudDatacenter> entry : this.datacenters.entrySet()) {
            ScyllaCloudDatacenter datacenter = entry.getValue();
            if (datacenter.getCertificateAuthorityData() != null) {
                certificateDataStream = new ByteArrayInputStream(datacenter.getCertificateAuthorityData());
            } else if (datacenter.getCertificateAuthorityPath() != null) {
                certificateDataStream = new FileInputStream(datacenter.getCertificateAuthorityPath());
            } else {
                throw new IllegalStateException("Neither CertificateAuthorityPath nor CertificateAuthorityData are set in this Datacenter object. Validation should have prevented this.");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(certificateDataStream);
            trustStore.setCertificateEntry(entry.getKey(), cert);
        }
        for (Map.Entry<String, Object> entry : this.authInfos.entrySet()) {
            PrivateKey privateKey;
            String keyString;
            ScyllaCloudAuthInfo authInfo = (ScyllaCloudAuthInfo)entry.getValue();
            if (authInfo.getClientCertificateData() != null) {
                certificateDataStream = new ByteArrayInputStream(authInfo.getClientCertificateData());
            } else if (authInfo.getClientCertificatePath() != null) {
                certificateDataStream = new FileInputStream(authInfo.getClientCertificatePath());
            } else {
                throw new RuntimeException("Neither CertificateAuthorityPath nor CertificateAuthorityData are set in this AuthInfo object. Validation should have prevented this.");
            }
            if (authInfo.getClientKeyData() != null) {
                keyString = new String(authInfo.getClientKeyData());
            } else if (authInfo.getClientKeyPath() != null) {
                BufferedReader br = new BufferedReader(new FileReader(authInfo.getClientKeyPath()));
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                keyString = sb.toString();
            } else {
                throw new RuntimeException("Neither ClientKeyData nor ClientKeyPath are set in this AuthInfo object. Validation should have prevented this.");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(certificateDataStream);
            Certificate[] certArr = new Certificate[]{cert};
            Security.addProvider(new BouncyCastleProvider());
            PEMParser pemParser = new PEMParser(new StringReader(keyString));
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            Object object = pemParser.readObject();
            if (object instanceof PrivateKeyInfo) {
                privateKey = converter.getPrivateKey((PrivateKeyInfo)object);
            } else if (object instanceof PEMKeyPair) {
                KeyPair kp = converter.getKeyPair((PEMKeyPair)object);
                privateKey = kp.getPrivate();
            } else {
                if (object == null) {
                    throw new IllegalStateException("Error parsing authInfo " + entry.getKey() + ". Somehow no objects are left in the stream. Is passed Client Key empty?");
                }
                throw new InvalidKeySpecException("Error parsing authInfo " + entry.getKey() + ". Make sure provided key signature is either 'RSA PRIVATE KEY' or 'PRIVATE KEY'");
            }
            identity.setKeyEntry(entry.getKey(), privateKey, "cassandra".toCharArray(), certArr);
        }
        return new ConfigurationBundle(identity, trustStore);
    }

    public ScyllaCloudDatacenter getCurrentDatacenter() {
        return this.datacenters.get(this.getCurrentContext().getDatacenterName());
    }

    public ScyllaCloudAuthInfo getCurrentAuthInfo() {
        return this.authInfos.get(this.getCurrentContext().getAuthInfoName());
    }

    public String getKind() {
        return this.kind;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Map<String, ScyllaCloudDatacenter> getDatacenters() {
        return this.datacenters;
    }

    public Map<String, ScyllaCloudAuthInfo> getAuthInfos() {
        return this.authInfos;
    }

    public Map<String, ScyllaCloudContext> getContexts() {
        return this.contexts;
    }

    public ScyllaCloudContext getCurrentContext() {
        return this.contexts.get(this.currentContext);
    }

    public Parameters getParameters() {
        return this.parameters;
    }
}

