/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.net.InetSocketAddress;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import shaded.com.scylladb.cdc.driver3.channel.socket.SocketChannel;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.ExtendedRemoteEndpointAwareSslOptions;
import shaded.com.scylladb.cdc.driver3.driver.core.JdkSSLOptions;
import shaded.com.scylladb.cdc.driver3.driver.core.SniEndPoint;
import shaded.com.scylladb.cdc.driver3.handler.ssl.SslHandler;

public class SniSSLOptions
extends JdkSSLOptions
implements ExtendedRemoteEndpointAwareSslOptions {
    private static final int FAKE_PORT_OFFSET = 49152;
    private final CopyOnWriteArrayList<String> fakePorts = new CopyOnWriteArrayList();

    protected SniSSLOptions(SSLContext context, String[] cipherSuites) {
        super(context, cipherSuites);
    }

    @Override
    public SslHandler newSSLHandler(SocketChannel channel) {
        throw new AssertionError((Object)"This class implements RemoteEndpointAwareSSLOptions, this method should not be called");
    }

    @Override
    public SslHandler newSSLHandler(SocketChannel channel, EndPoint remoteEndpoint) {
        SSLEngine engine = this.newSSLEngine(channel, remoteEndpoint);
        return new SslHandler(engine);
    }

    @Override
    public SslHandler newSSLHandler(SocketChannel channel, InetSocketAddress remoteEndpoint) {
        throw new AssertionError((Object)("The driver should never call this method on an object that implements " + this.getClass().getSimpleName()));
    }

    protected SSLEngine newSSLEngine(SocketChannel channel, EndPoint remoteEndpoint) {
        if (!(remoteEndpoint instanceof SniEndPoint)) {
            throw new IllegalArgumentException(String.format("Configuration error: can only use %s with SNI end points", this.getClass().getSimpleName()));
        }
        SniEndPoint sniEndPoint = (SniEndPoint)remoteEndpoint;
        InetSocketAddress address = sniEndPoint.resolve();
        String sniServerName = sniEndPoint.getServerName();
        SSLEngine engine = this.context.createSSLEngine(address.getHostName(), this.getFakePort(sniServerName));
        engine.setUseClientMode(true);
        SSLParameters parameters = engine.getSSLParameters();
        parameters.setServerNames(ImmutableList.of(new SNIHostName(sniServerName)));
        parameters.setEndpointIdentificationAlgorithm("HTTPS");
        engine.setSSLParameters(parameters);
        if (this.cipherSuites != null) {
            engine.setEnabledCipherSuites(this.cipherSuites);
        }
        return engine;
    }

    private int getFakePort(String sniServerName) {
        this.fakePorts.addIfAbsent(sniServerName);
        return 49152 + this.fakePorts.indexOf(sniServerName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JdkSSLOptions.Builder {
        @Override
        public Builder withSSLContext(SSLContext context) {
            super.withSSLContext(context);
            return this;
        }

        @Override
        public Builder withCipherSuites(String[] cipherSuites) {
            super.withCipherSuites(cipherSuites);
            return this;
        }

        @Override
        public SniSSLOptions build() {
            return new SniSSLOptions(this.context, this.cipherSuites);
        }
    }
}

