/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableMap;
import shaded.com.scylladb.cdc.driver3.driver.core.BatchStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.PagingState;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.QueryOptions;
import shaded.com.scylladb.cdc.driver3.driver.core.Token;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.PagingStateException;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.RetryPolicy;

public abstract class Statement {
    public static final ByteBuffer NULL_PAYLOAD_VALUE = ByteBuffer.allocate(0);
    static final Statement DEFAULT = new Statement(){

        @Override
        public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
            return null;
        }

        @Override
        public String getKeyspace() {
            return null;
        }

        @Override
        public ConsistencyLevel getConsistencyLevel() {
            return ConsistencyLevel.ONE;
        }
    };
    private volatile ConsistencyLevel consistency;
    private volatile ConsistencyLevel serialConsistency;
    private volatile boolean traceQuery;
    private volatile int fetchSize;
    private volatile long defaultTimestamp = Long.MIN_VALUE;
    private volatile int readTimeoutMillis = Integer.MIN_VALUE;
    private volatile RetryPolicy retryPolicy;
    private volatile ByteBuffer pagingState;
    protected volatile Boolean idempotent;
    private volatile Map<String, ByteBuffer> outgoingPayload;
    private volatile Host host;
    private volatile Host lastHost;
    private volatile int nowInSeconds = Integer.MIN_VALUE;

    Statement() {
    }

    public boolean isLWT() {
        return false;
    }

    public Statement setConsistencyLevel(ConsistencyLevel consistency) {
        this.consistency = consistency;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public Statement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        if (!serialConsistency.isSerial()) {
            throw new IllegalArgumentException("Supplied consistency level is not serial: " + (Object)((Object)serialConsistency));
        }
        this.serialConsistency = serialConsistency;
        return this;
    }

    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    public Statement enableTracing() {
        this.traceQuery = true;
        return this;
    }

    public Statement disableTracing() {
        this.traceQuery = false;
        return this;
    }

    public boolean isTracing() {
        return this.traceQuery;
    }

    public abstract ByteBuffer getRoutingKey(ProtocolVersion var1, CodecRegistry var2);

    public abstract String getKeyspace();

    public Token.Factory getPartitioner() {
        return null;
    }

    public Statement setRetryPolicy(RetryPolicy policy) {
        this.retryPolicy = policy;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Statement setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Statement setDefaultTimestamp(long defaultTimestamp) {
        this.defaultTimestamp = defaultTimestamp;
        return this;
    }

    public long getDefaultTimestamp() {
        return this.defaultTimestamp;
    }

    public Statement setReadTimeoutMillis(int readTimeoutMillis) {
        Preconditions.checkArgument(readTimeoutMillis >= 0, "read timeout must be >= 0");
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Statement setPagingState(PagingState pagingState, CodecRegistry codecRegistry) {
        if (this instanceof BatchStatement) {
            throw new UnsupportedOperationException("Cannot set the paging state on a batch statement");
        }
        if (pagingState == null) {
            this.pagingState = null;
        } else if (pagingState.matches(this, codecRegistry)) {
            this.pagingState = pagingState.getRawState();
        } else {
            throw new PagingStateException("Paging state mismatch, this means that either the paging state contents were altered, or you're trying to apply it to a different statement");
        }
        return this;
    }

    public Statement setPagingState(PagingState pagingState) {
        return this.setPagingState(pagingState, CodecRegistry.DEFAULT_INSTANCE);
    }

    public Statement setPagingStateUnsafe(byte[] pagingState) {
        this.pagingState = pagingState == null ? null : ByteBuffer.wrap(pagingState);
        return this;
    }

    ByteBuffer getPagingState() {
        return this.pagingState;
    }

    public Statement setIdempotent(boolean idempotent) {
        this.idempotent = idempotent;
        return this;
    }

    public Boolean isIdempotent() {
        return this.idempotent;
    }

    boolean isIdempotentWithDefault(QueryOptions queryOptions) {
        Boolean myValue = this.isIdempotent();
        if (myValue != null) {
            return myValue;
        }
        return queryOptions.getDefaultIdempotence();
    }

    public Map<String, ByteBuffer> getOutgoingPayload() {
        return this.outgoingPayload;
    }

    public Statement setOutgoingPayload(Map<String, ByteBuffer> payload) {
        this.outgoingPayload = payload == null ? null : ImmutableMap.copyOf(payload);
        return this;
    }

    public int requestSizeInBytes(ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        return -1;
    }

    protected static Boolean isBatchIdempotent(Collection<? extends Statement> statements) {
        boolean hasNullIdempotentStatements = false;
        for (Statement statement : statements) {
            Boolean innerIdempotent = statement.isIdempotent();
            if (innerIdempotent == null) {
                hasNullIdempotentStatements = true;
                continue;
            }
            if (innerIdempotent.booleanValue()) continue;
            return false;
        }
        return hasNullIdempotentStatements ? null : Boolean.valueOf(true);
    }

    public Host getHost() {
        return this.host;
    }

    public Statement setHost(Host host) {
        this.host = host;
        return this;
    }

    public Host getLastHost() {
        return this.lastHost;
    }

    public void setLastHost(Host host) {
        this.lastHost = host;
    }

    public int getNowInSeconds() {
        return this.nowInSeconds;
    }

    public Statement setNowInSeconds(int nowInSeconds) {
        this.nowInSeconds = nowInSeconds;
        return this;
    }
}

