/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.scylladb.cdc.driver3.common.annotations.Beta;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableCollection;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.TupleType;
import shaded.com.scylladb.cdc.driver3.driver.core.TupleValue;
import shaded.com.scylladb.cdc.driver3.driver.core.TypeCodec;

@Beta
public class TabletMap {
    private static final Logger logger = LoggerFactory.getLogger(TabletMap.class);
    private static final ImmutableList<Host> EMPTY_LIST = ImmutableList.of();
    private final ConcurrentMap<KeyspaceTableNamePair, TabletSet> mapping;
    private final Cluster.Manager cluster;
    private TupleType payloadOuterTuple = null;
    private TupleType payloadInnerTuple = null;
    private TypeCodec<TupleValue> tabletPayloadCodec = null;

    public TabletMap(Cluster.Manager cluster, ConcurrentMap<KeyspaceTableNamePair, TabletSet> mapping) {
        this.cluster = cluster;
        this.mapping = mapping;
    }

    public static TabletMap emptyMap(Cluster.Manager cluster) {
        return new TabletMap(cluster, new ConcurrentHashMap<KeyspaceTableNamePair, TabletSet>());
    }

    public Map<KeyspaceTableNamePair, TabletSet> getMapping() {
        return this.mapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Host> getReplicas(String keyspace, String table, long token) {
        KeyspaceTableNamePair key = new KeyspaceTableNamePair(keyspace, table);
        if (this.mapping == null) {
            logger.trace("This tablets map is null. Returning empty set.");
            return EMPTY_LIST;
        }
        TabletSet tabletSet = (TabletSet)this.mapping.get(key);
        if (tabletSet == null) {
            logger.trace("There is no tablets for {}.{} in this mapping. Returning empty set.", (Object)keyspace, (Object)table);
            return EMPTY_LIST;
        }
        ReentrantReadWriteLock.ReadLock readLock = tabletSet.lock.readLock();
        try {
            readLock.lock();
            Tablet row = ((TabletSet)this.mapping.get((Object)key)).tablets.ceiling(Tablet.malformedTablet(token));
            if (row == null || row.firstToken >= token) {
                logger.trace("Could not find tablet for {}.{} that owns token {}. Returning empty set.", new Object[]{keyspace, table, token});
                ImmutableList<Host> immutableList = EMPTY_LIST;
                return immutableList;
            }
            ImmutableList.Builder replicas = new ImmutableList.Builder();
            for (HostShardPair hostShardPair : row.replicas) {
                Host replica = this.cluster.metadata.getHost(hostShardPair.getHost());
                if (replica == null) {
                    ImmutableList<Host> immutableList = EMPTY_LIST;
                    return immutableList;
                }
                replicas.add(replica);
            }
            ImmutableCollection immutableCollection = replicas.build();
            return immutableCollection;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTabletsRoutingV1Payload(String keyspace, String table, ByteBuffer payload) {
        TupleValue tupleValue = this.getTabletPayloadCodec().deserialize(payload, this.cluster.protocolVersion());
        KeyspaceTableNamePair ktPair = new KeyspaceTableNamePair(keyspace, table);
        long firstToken = tupleValue.getLong(0);
        long lastToken = tupleValue.getLong(1);
        logger.trace("Received tablets routing V1 payload: {}.{} range {}-{}", new Object[]{keyspace, table, firstToken, lastToken});
        ArrayList<HostShardPair> replicas = new ArrayList<HostShardPair>();
        List list = tupleValue.getList(2, TupleValue.class);
        for (TupleValue tuple : list) {
            HostShardPair hostShardPair = new HostShardPair(tuple.getUUID(0), tuple.getInt(1));
            replicas.add(hostShardPair);
        }
        Tablet newTablet = new Tablet(keyspace, null, table, firstToken, lastToken, replicas);
        TabletSet tabletSet = this.mapping.computeIfAbsent(ktPair, k -> new TabletSet());
        ReentrantReadWriteLock.WriteLock writeLock = tabletSet.lock.writeLock();
        try {
            Tablet tablet;
            writeLock.lock();
            NavigableSet<Tablet> currentTablets = tabletSet.tablets;
            Iterator<Tablet> it = currentTablets.headSet(newTablet, true).descendingIterator();
            while (it.hasNext() && (tablet = it.next()).lastToken > firstToken) {
                it.remove();
            }
            it = currentTablets.tailSet(newTablet, true).iterator();
            while (it.hasNext() && (tablet = it.next()).firstToken < lastToken) {
                it.remove();
            }
            currentTablets.add(newTablet);
        }
        finally {
            writeLock.unlock();
        }
    }

    public TupleType getPayloadOuterTuple() {
        if (this.payloadOuterTuple == null) {
            this.payloadOuterTuple = this.cluster.metadata.newTupleType(DataType.bigint(), DataType.bigint(), DataType.list(this.getPayloadInnerTuple()));
        }
        return this.payloadOuterTuple;
    }

    public TupleType getPayloadInnerTuple() {
        if (this.payloadInnerTuple == null) {
            this.payloadInnerTuple = this.cluster.metadata.newTupleType(DataType.uuid(), DataType.cint());
        }
        return this.payloadInnerTuple;
    }

    public TypeCodec<TupleValue> getTabletPayloadCodec() {
        if (this.tabletPayloadCodec == null) {
            this.tabletPayloadCodec = this.cluster.configuration.getCodecRegistry().codecFor(this.getPayloadOuterTuple());
        }
        return this.tabletPayloadCodec;
    }

    public void removeTableMappings(KeyspaceTableNamePair key) {
        this.mapping.remove(key);
    }

    public void removeTableMappings(String keyspace, String table) {
        this.removeTableMappings(new KeyspaceTableNamePair(keyspace, table));
    }

    public void removeTableMappings(String keyspace) {
        Iterator<KeyspaceTableNamePair> it = this.getMapping().keySet().iterator();
        while (it.hasNext()) {
            KeyspaceTableNamePair key = it.next();
            if (!key.getKeyspace().equals(keyspace)) continue;
            it.remove();
        }
    }

    public static class Tablet
    implements Comparable<Tablet> {
        private final String keyspaceName;
        private final UUID tableId;
        private final String tableName;
        private final long firstToken;
        private final long lastToken;
        private final List<HostShardPair> replicas;

        private Tablet(String keyspaceName, UUID tableId, String tableName, long firstToken, long lastToken, List<HostShardPair> replicas) {
            this.keyspaceName = keyspaceName;
            this.tableId = tableId;
            this.tableName = tableName;
            this.firstToken = firstToken;
            this.lastToken = lastToken;
            this.replicas = replicas;
        }

        public static Tablet malformedTablet(long lastToken) {
            return new Tablet(null, null, null, lastToken, lastToken, null);
        }

        public String getKeyspaceName() {
            return this.keyspaceName;
        }

        public UUID getTableId() {
            return this.tableId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public long getFirstToken() {
            return this.firstToken;
        }

        public long getLastToken() {
            return this.lastToken;
        }

        public List<HostShardPair> getReplicas() {
            return this.replicas;
        }

        public String toString() {
            return "LazyTablet{keyspaceName='" + this.keyspaceName + '\'' + ", tableId=" + this.tableId + ", tableName='" + this.tableName + '\'' + ", firstToken=" + this.firstToken + ", lastToken=" + this.lastToken + ", replicas=" + this.replicas + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tablet that = (Tablet)o;
            return this.firstToken == that.firstToken && this.lastToken == that.lastToken && this.keyspaceName.equals(that.keyspaceName) && Objects.equals(this.tableId, that.tableId) && this.tableName.equals(that.tableName) && Objects.equals(this.replicas, that.replicas);
        }

        public int hashCode() {
            return Objects.hash(this.keyspaceName, this.tableId, this.tableName, this.firstToken, this.lastToken, this.replicas);
        }

        @Override
        public int compareTo(Tablet tablet) {
            return Long.compare(this.lastToken, tablet.lastToken);
        }
    }

    public static class TabletSet {
        final NavigableSet<Tablet> tablets;
        final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        public TabletSet() {
            this.tablets = new TreeSet<Tablet>();
        }
    }

    public static class KeyspaceTableNamePair {
        private final String keyspace;
        private final String tableName;

        public KeyspaceTableNamePair(String keyspace, String tableName) {
            this.keyspace = keyspace;
            this.tableName = tableName;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return "KeyspaceTableNamePair{keyspace='" + this.keyspace + '\'' + ", tableName='" + this.tableName + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyspaceTableNamePair that = (KeyspaceTableNamePair)o;
            return this.keyspace.equals(that.keyspace) && this.tableName.equals(that.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.keyspace, this.tableName);
        }
    }

    public static class HostShardPair {
        private final UUID host;
        private final int shard;

        public HostShardPair(UUID host, int shard) {
            this.host = host;
            this.shard = shard;
        }

        public UUID getHost() {
            return this.host;
        }

        public int getShard() {
            return this.shard;
        }

        public String toString() {
            return "HostShardPair{host=" + this.host + ", shard=" + this.shard + '}';
        }
    }
}

