/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core;

import java.util.Arrays;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.common.collect.ImmutableList;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.TupleValue;

public class TupleType
extends DataType {
    private final List<DataType> types;
    private final ProtocolVersion protocolVersion;
    private volatile CodecRegistry codecRegistry;

    TupleType(List<DataType> types, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        super(DataType.Name.TUPLE);
        this.types = ImmutableList.copyOf(types);
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
    }

    public static TupleType of(ProtocolVersion protocolVersion, CodecRegistry codecRegistry, DataType ... types) {
        return new TupleType(Arrays.asList(types), protocolVersion, codecRegistry);
    }

    public List<DataType> getComponentTypes() {
        return this.types;
    }

    public TupleValue newValue() {
        return new TupleValue(this);
    }

    public TupleValue newValue(Object ... values) {
        if (values.length != this.types.size()) {
            throw new IllegalArgumentException(String.format("Invalid number of values. Expecting %d but got %d", this.types.size(), values.length));
        }
        TupleValue t2 = this.newValue();
        for (int i = 0; i < values.length; ++i) {
            DataType dataType = this.types.get(i);
            if (values[i] == null) {
                t2.setValue(i, null);
                continue;
            }
            t2.setValue(i, this.codecRegistry.codecFor(dataType, values[i]).serialize(values[i], this.protocolVersion));
        }
        return t2;
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    void setCodecRegistry(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.types});
    }

    public boolean equals(Object o) {
        if (!(o instanceof TupleType)) {
            return false;
        }
        TupleType d = (TupleType)o;
        return this.name == d.name && this.types.equals(d.types);
    }

    public boolean contains(TupleType other) {
        if (this.equals(other)) {
            return true;
        }
        if (other.types.size() > this.types.size()) {
            return false;
        }
        return this.types.subList(0, other.types.size()).equals(other.types);
    }

    public String toString() {
        return "frozen<" + this.asFunctionParameterString() + ">";
    }

    @Override
    public String asFunctionParameterString() {
        StringBuilder sb = new StringBuilder();
        for (DataType type : this.types) {
            sb.append(sb.length() == 0 ? "tuple<" : ", ");
            sb.append(type.asFunctionParameterString());
        }
        return sb.append(">").toString();
    }
}

