/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.CoordinatorException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.DriverException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.QueryValidationException;

public class AlreadyExistsException
extends QueryValidationException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;
    private final String keyspace;
    private final String table;

    public AlreadyExistsException(String keyspace, String table) {
        this(null, keyspace, table);
    }

    public AlreadyExistsException(EndPoint endPoint, String keyspace, String table) {
        super(AlreadyExistsException.makeMsg(keyspace, table));
        this.endPoint = endPoint;
        this.keyspace = keyspace;
        this.table = table;
    }

    private AlreadyExistsException(EndPoint endPoint, String msg, Throwable cause, String keyspace, String table) {
        super(msg, cause);
        this.endPoint = endPoint;
        this.keyspace = keyspace;
        this.table = table;
    }

    private static String makeMsg(String keyspace, String table) {
        if (table.isEmpty()) {
            return String.format("Keyspace %s already exists", keyspace);
        }
        return String.format("Table %s.%s already exists", keyspace, table);
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    public boolean wasTableCreation() {
        return !this.table.isEmpty();
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.table.isEmpty() ? null : this.table;
    }

    @Override
    public DriverException copy() {
        return new AlreadyExistsException(this.getEndPoint(), this.getMessage(), this, this.keyspace, this.table);
    }

    public AlreadyExistsException copy(EndPoint endPoint) {
        return new AlreadyExistsException(endPoint, this.getMessage(), this, this.keyspace, this.table);
    }
}

