/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.CoordinatorException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.DriverException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.WrappingEndPoint;

public class AuthenticationException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public AuthenticationException(EndPoint endPoint, String message) {
        super(String.format("Authentication error on host %s: %s", endPoint, message));
        this.endPoint = endPoint;
    }

    public AuthenticationException(InetSocketAddress address, String message) {
        this(new WrappingEndPoint(address), message);
    }

    private AuthenticationException(EndPoint endPoint, String message, Throwable cause) {
        super(message, cause);
        this.endPoint = endPoint;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public DriverException copy() {
        return new AuthenticationException(this.endPoint, this.getMessage(), this);
    }
}

