/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.CoordinatorException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.DriverInternalError;

public class ProtocolError
extends DriverInternalError
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public ProtocolError(EndPoint endPoint, String message) {
        super(String.format("An unexpected protocol error occurred on host %s. This is a bug in this library, please report: %s", endPoint, message));
        this.endPoint = endPoint;
    }

    private ProtocolError(EndPoint endPoint, String message, ProtocolError cause) {
        super(message, cause);
        this.endPoint = endPoint;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public ProtocolError copy() {
        return new ProtocolError(this.endPoint, this.getMessage(), this);
    }
}

