/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.CoordinatorException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.QueryExecutionException;

public abstract class QueryConsistencyException
extends QueryExecutionException
implements CoordinatorException {
    private final EndPoint endPoint;
    private final ConsistencyLevel consistency;
    private final int received;
    private final int required;

    protected QueryConsistencyException(EndPoint endPoint, String msg, ConsistencyLevel consistency, int received, int required) {
        super(msg);
        this.endPoint = endPoint;
        this.consistency = consistency;
        this.received = received;
        this.required = required;
    }

    protected QueryConsistencyException(EndPoint endPoint, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required) {
        super(msg, cause);
        this.endPoint = endPoint;
        this.consistency = consistency;
        this.received = received;
        this.required = required;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public int getReceivedAcknowledgements() {
        return this.received;
    }

    public int getRequiredAcknowledgements() {
        return this.required;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }
}

