/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.QueryConsistencyException;

public class ReadTimeoutException
extends QueryConsistencyException {
    private static final long serialVersionUID = 0L;
    private final boolean dataPresent;

    public ReadTimeoutException(ConsistencyLevel consistency, int received, int required, boolean dataPresent) {
        this(null, consistency, received, required, dataPresent);
    }

    public ReadTimeoutException(EndPoint endPoint, ConsistencyLevel consistency, int received, int required, boolean dataPresent) {
        super(endPoint, String.format("Cassandra timeout during read query at consistency %s (%s). In case this was generated during read repair, the consistency level is not representative of the actual consistency.", new Object[]{consistency, ReadTimeoutException.formatDetails(received, required, dataPresent)}), consistency, received, required);
        this.dataPresent = dataPresent;
    }

    private ReadTimeoutException(EndPoint endPoint, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required, boolean dataPresent) {
        super(endPoint, msg, cause, consistency, received, required);
        this.dataPresent = dataPresent;
    }

    private static String formatDetails(int received, int required, boolean dataPresent) {
        if (received < required) {
            return String.format("%d responses were required but only %d replica responded", required, received);
        }
        if (!dataPresent) {
            return "the replica queried for data didn't respond";
        }
        return "timeout while waiting for repair of inconsistent replica";
    }

    public boolean wasDataRetrieved() {
        return this.dataPresent;
    }

    @Override
    public ReadTimeoutException copy() {
        return new ReadTimeoutException(this.getEndPoint(), this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.wasDataRetrieved());
    }

    public ReadTimeoutException copy(EndPoint endPoint) {
        return new ReadTimeoutException(endPoint, this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.wasDataRetrieved());
    }
}

