/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.CoordinatorException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.DriverInternalError;

public class ServerError
extends DriverInternalError
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public ServerError(EndPoint endPoint, String message) {
        super(String.format("An unexpected error occurred server side on %s: %s", endPoint, message));
        this.endPoint = endPoint;
    }

    private ServerError(EndPoint endPoint, String message, ServerError cause) {
        super(message, cause);
        this.endPoint = endPoint;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public ServerError copy() {
        return new ServerError(this.endPoint, this.getMessage(), this);
    }
}

