/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.CoordinatorException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.QueryExecutionException;

public class UnavailableException
extends QueryExecutionException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;
    private final ConsistencyLevel consistency;
    private final int required;
    private final int alive;

    public UnavailableException(ConsistencyLevel consistency, int required, int alive) {
        this(null, consistency, required, alive);
    }

    public UnavailableException(EndPoint endPoint, ConsistencyLevel consistency, int required, int alive) {
        super(String.format("Not enough replicas available for query at consistency %s (%d required but only %d alive)", new Object[]{consistency, required, alive}));
        this.endPoint = endPoint;
        this.consistency = consistency;
        this.required = required;
        this.alive = alive;
    }

    private UnavailableException(EndPoint endPoint, String message, Throwable cause, ConsistencyLevel consistency, int required, int alive) {
        super(message, cause);
        this.endPoint = endPoint;
        this.consistency = consistency;
        this.required = required;
        this.alive = alive;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public int getRequiredReplicas() {
        return this.required;
    }

    public int getAliveReplicas() {
        return this.alive;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public UnavailableException copy() {
        return new UnavailableException(this.getEndPoint(), this.getMessage(), this, this.consistency, this.required, this.alive);
    }

    public UnavailableException copy(EndPoint endPoint) {
        return new UnavailableException(endPoint, this.getMessage(), this, this.consistency, this.required, this.alive);
    }
}

