/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.ProtocolVersion;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.CoordinatorException;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.DriverException;

public class UnsupportedProtocolVersionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;
    private final ProtocolVersion unsupportedVersion;
    private final ProtocolVersion serverVersion;

    public UnsupportedProtocolVersionException(EndPoint endPoint, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion) {
        super(UnsupportedProtocolVersionException.makeErrorMessage(endPoint, unsupportedVersion, serverVersion));
        this.endPoint = endPoint;
        this.unsupportedVersion = unsupportedVersion;
        this.serverVersion = serverVersion;
    }

    public UnsupportedProtocolVersionException(EndPoint endPoint, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion, Throwable cause) {
        super(UnsupportedProtocolVersionException.makeErrorMessage(endPoint, unsupportedVersion, serverVersion), cause);
        this.endPoint = endPoint;
        this.unsupportedVersion = unsupportedVersion;
        this.serverVersion = serverVersion;
    }

    private static String makeErrorMessage(EndPoint endPoint, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion) {
        return unsupportedVersion == serverVersion ? String.format("[%s] Host does not support protocol version %s", new Object[]{endPoint, unsupportedVersion}) : String.format("[%s] Host does not support protocol version %s but %s", new Object[]{endPoint, unsupportedVersion, serverVersion});
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public ProtocolVersion getUnsupportedVersion() {
        return this.unsupportedVersion;
    }

    @Override
    public UnsupportedProtocolVersionException copy() {
        return new UnsupportedProtocolVersionException(this.endPoint, this.unsupportedVersion, this.serverVersion, this);
    }
}

