/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.WriteType;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.QueryConsistencyException;

public class WriteFailureException
extends QueryConsistencyException {
    private final WriteType writeType;
    private final int failed;
    private final Map<InetAddress, Integer> failuresMap;

    public WriteFailureException(ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed, Map<InetAddress, Integer> failuresMap) {
        this(null, consistency, writeType, received, required, failed, failuresMap);
    }

    @Deprecated
    public WriteFailureException(ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        this(null, consistency, writeType, received, required, failed, Collections.emptyMap());
    }

    public WriteFailureException(EndPoint endPoint, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed, Map<InetAddress, Integer> failuresMap) {
        super(endPoint, String.format("Cassandra failure during write query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
        this.failuresMap = failuresMap;
    }

    @Deprecated
    public WriteFailureException(EndPoint endPoint, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        this(endPoint, consistency, writeType, received, required, failed, Collections.emptyMap());
    }

    private WriteFailureException(EndPoint endPoint, String msg, Throwable cause, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed, Map<InetAddress, Integer> failuresMap) {
        super(endPoint, msg, cause, consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
        this.failuresMap = failuresMap;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    public int getFailures() {
        return this.failed;
    }

    public Map<InetAddress, Integer> getFailuresMap() {
        return this.failuresMap;
    }

    @Override
    public WriteFailureException copy() {
        return new WriteFailureException(this.getEndPoint(), this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures(), this.failuresMap);
    }

    public WriteFailureException copy(EndPoint endPoint) {
        return new WriteFailureException(endPoint, this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.failed, this.failuresMap);
    }
}

