/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.exceptions;

import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPoint;
import shaded.com.scylladb.cdc.driver3.driver.core.WriteType;
import shaded.com.scylladb.cdc.driver3.driver.core.exceptions.QueryConsistencyException;

public class WriteTimeoutException
extends QueryConsistencyException {
    private static final long serialVersionUID = 0L;
    private final WriteType writeType;

    public WriteTimeoutException(ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        this(null, consistency, writeType, received, required);
    }

    public WriteTimeoutException(EndPoint endPoint, ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        super(endPoint, String.format("Cassandra timeout during %s write query at consistency %s (%d replica were required but only %d acknowledged the write)", new Object[]{writeType, consistency, required, received}), consistency, received, required);
        this.writeType = writeType;
    }

    private WriteTimeoutException(EndPoint endPoint, String msg, Throwable cause, ConsistencyLevel consistency, WriteType writeType, int received, int required) {
        super(endPoint, msg, cause, consistency, received, required);
        this.writeType = writeType;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    @Override
    public WriteTimeoutException copy() {
        return new WriteTimeoutException(this.getEndPoint(), this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements());
    }

    public WriteTimeoutException copy(EndPoint address) {
        return new WriteTimeoutException(address, this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements());
    }
}

