/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.policies;

import java.util.concurrent.atomic.AtomicInteger;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.SpeculativeExecutionPolicy;

public class ConstantSpeculativeExecutionPolicy
implements SpeculativeExecutionPolicy {
    private final int maxSpeculativeExecutions;
    private final long constantDelayMillis;

    public ConstantSpeculativeExecutionPolicy(long constantDelayMillis, int maxSpeculativeExecutions) {
        Preconditions.checkArgument(constantDelayMillis >= 0L, "delay must be >= 0 (was %d)", new Object[]{constantDelayMillis});
        Preconditions.checkArgument(maxSpeculativeExecutions > 0, "number of speculative executions must be strictly positive (was %d)", new Object[]{maxSpeculativeExecutions});
        this.constantDelayMillis = constantDelayMillis;
        this.maxSpeculativeExecutions = maxSpeculativeExecutions;
    }

    @Override
    public SpeculativeExecutionPolicy.SpeculativeExecutionPlan newPlan(String loggedKeyspace, Statement statement) {
        return new SpeculativeExecutionPolicy.SpeculativeExecutionPlan(){
            private final AtomicInteger remaining;
            {
                this.remaining = new AtomicInteger(ConstantSpeculativeExecutionPolicy.this.maxSpeculativeExecutions);
            }

            @Override
            public long nextExecution(Host lastQueried) {
                return this.remaining.getAndDecrement() > 0 ? ConstantSpeculativeExecutionPolicy.this.constantDelayMillis : -1L;
            }
        };
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }
}

