/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.policies;

import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.ReconnectionPolicy;

public class ExponentialReconnectionPolicy
implements ReconnectionPolicy {
    private final long baseDelayMs;
    private final long maxDelayMs;
    private final long maxAttempts;

    public ExponentialReconnectionPolicy(long baseDelayMs, long maxDelayMs) {
        if (baseDelayMs < 0L || maxDelayMs < 0L) {
            throw new IllegalArgumentException("Invalid negative delay");
        }
        if (baseDelayMs == 0L) {
            throw new IllegalArgumentException("baseDelayMs must be strictly positive");
        }
        if (maxDelayMs < baseDelayMs) {
            throw new IllegalArgumentException(String.format("maxDelayMs (got %d) cannot be smaller than baseDelayMs (got %d)", maxDelayMs, baseDelayMs));
        }
        this.baseDelayMs = baseDelayMs;
        this.maxDelayMs = maxDelayMs;
        int ceil = (baseDelayMs & baseDelayMs - 1L) == 0L ? 0 : 1;
        this.maxAttempts = 64 - Long.numberOfLeadingZeros(Long.MAX_VALUE / baseDelayMs) - ceil;
    }

    public long getBaseDelayMs() {
        return this.baseDelayMs;
    }

    public long getMaxDelayMs() {
        return this.maxDelayMs;
    }

    @Override
    public ReconnectionPolicy.ReconnectionSchedule newSchedule() {
        return new ExponentialSchedule();
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }

    private class ExponentialSchedule
    implements ReconnectionPolicy.ReconnectionSchedule {
        private int attempts;

        private ExponentialSchedule() {
        }

        @Override
        public long nextDelayMs() {
            if ((long)this.attempts > ExponentialReconnectionPolicy.this.maxAttempts) {
                return ExponentialReconnectionPolicy.this.maxDelayMs;
            }
            return Math.min(ExponentialReconnectionPolicy.this.baseDelayMs * (1L << this.attempts++), ExponentialReconnectionPolicy.this.maxDelayMs);
        }
    }
}

