/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.policies;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.HostDistance;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.LoadBalancingPolicy;

public class PagingOptimizingLoadBalancingPolicy
implements LoadBalancingPolicy {
    private final LoadBalancingPolicy wrapped;
    private volatile CopyOnWriteArrayList<Host> hosts;

    public PagingOptimizingLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
        this.wrapped = loadBalancingPolicy;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.hosts = new CopyOnWriteArrayList<Host>(hosts);
        this.wrapped.init(cluster, hosts);
    }

    @Override
    public HostDistance distance(Host host) {
        return this.wrapped.distance(host);
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        WithFirstIterator inner = this.wrapped.newQueryPlan(loggedKeyspace, statement);
        Host lastHost = statement.getLastHost();
        return lastHost == null ? inner : new WithFirstIterator(lastHost, inner);
    }

    @Override
    public void onAdd(Host host) {
        this.hosts.addIfAbsent(host);
        this.wrapped.onAdd(host);
    }

    @Override
    public void onUp(Host host) {
        this.hosts.addIfAbsent(host);
        this.wrapped.onUp(host);
    }

    @Override
    public void onDown(Host host) {
        this.hosts.remove(host);
        this.wrapped.onDown(host);
    }

    @Override
    public void onRemove(Host host) {
        this.hosts.remove(host);
        this.wrapped.onRemove(host);
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    private class WithFirstIterator
    implements Iterator<Host> {
        private Host firstToReturn;
        private final Iterator<Host> wrapped;

        public WithFirstIterator(Host host, Iterator<Host> iterator) {
            this.firstToReturn = host;
            this.wrapped = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext() || this.hasValidFirstToReturn();
        }

        @Override
        public Host next() {
            if (this.hasValidFirstToReturn()) {
                Host result = this.firstToReturn;
                this.firstToReturn = null;
                return result;
            }
            return this.wrapped.next();
        }

        private boolean hasValidFirstToReturn() {
            if (this.firstToReturn == null) {
                return false;
            }
            return PagingOptimizingLoadBalancingPolicy.this.hosts.contains(this.firstToReturn);
        }
    }
}

