/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.policies;

import java.util.concurrent.atomic.AtomicInteger;
import shaded.com.scylladb.cdc.driver3.common.base.Preconditions;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.PercentileTracker;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.SpeculativeExecutionPolicy;

public class PercentileSpeculativeExecutionPolicy
implements SpeculativeExecutionPolicy {
    private final PercentileTracker percentileTracker;
    private final double percentile;
    private final int maxSpeculativeExecutions;

    public PercentileSpeculativeExecutionPolicy(PercentileTracker percentileTracker, double percentile, int maxSpeculativeExecutions) {
        Preconditions.checkArgument(maxSpeculativeExecutions > 0, "number of speculative executions must be strictly positive (was %d)", new Object[]{maxSpeculativeExecutions});
        Preconditions.checkArgument(percentile >= 0.0 && percentile < 100.0, "percentile must be between 0.0 and 100 (was %f)");
        this.percentileTracker = percentileTracker;
        this.percentile = percentile;
        this.maxSpeculativeExecutions = maxSpeculativeExecutions;
    }

    @Override
    public SpeculativeExecutionPolicy.SpeculativeExecutionPlan newPlan(String loggedKeyspace, Statement statement) {
        return new SpeculativeExecutionPolicy.SpeculativeExecutionPlan(){
            private final AtomicInteger remaining;
            {
                this.remaining = new AtomicInteger(PercentileSpeculativeExecutionPolicy.this.maxSpeculativeExecutions);
            }

            @Override
            public long nextExecution(Host lastQueried) {
                if (this.remaining.getAndDecrement() > 0) {
                    return PercentileSpeculativeExecutionPolicy.this.percentileTracker.getLatencyAtPercentile(lastQueried, null, null, PercentileSpeculativeExecutionPolicy.this.percentile);
                }
                return -1L;
            }
        };
    }

    @Override
    public void init(Cluster cluster) {
        cluster.register(this.percentileTracker);
    }

    @Override
    public void close() {
    }
}

