/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.policies;

import shaded.com.scylladb.cdc.driver3.driver.core.AtomicMonotonicTimestampGenerator;
import shaded.com.scylladb.cdc.driver3.driver.core.DefaultEndPointFactory;
import shaded.com.scylladb.cdc.driver3.driver.core.EndPointFactory;
import shaded.com.scylladb.cdc.driver3.driver.core.TimestampGenerator;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.AddressTranslator;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.DCAwareRoundRobinPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.DefaultRetryPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.ExponentialReconnectionPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.IdentityTranslator;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.LoadBalancingPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.NoSpeculativeExecutionPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.ReconnectionPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.RetryPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.SpeculativeExecutionPolicy;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.TokenAwarePolicy;

public class Policies {
    private static final ReconnectionPolicy DEFAULT_RECONNECTION_POLICY = new ExponentialReconnectionPolicy(1000L, 600000L);
    private static final RetryPolicy DEFAULT_RETRY_POLICY = DefaultRetryPolicy.INSTANCE;
    private static final AddressTranslator DEFAULT_ADDRESS_TRANSLATOR = new IdentityTranslator();
    private static final SpeculativeExecutionPolicy DEFAULT_SPECULATIVE_EXECUTION_POLICY = NoSpeculativeExecutionPolicy.INSTANCE;
    private final LoadBalancingPolicy loadBalancingPolicy;
    private final ReconnectionPolicy reconnectionPolicy;
    private final RetryPolicy retryPolicy;
    private final AddressTranslator addressTranslator;
    private final TimestampGenerator timestampGenerator;
    private final SpeculativeExecutionPolicy speculativeExecutionPolicy;
    private final EndPointFactory endPointFactory;

    public static Builder builder() {
        return new Builder();
    }

    private Policies(LoadBalancingPolicy loadBalancingPolicy, ReconnectionPolicy reconnectionPolicy, RetryPolicy retryPolicy, AddressTranslator addressTranslator, TimestampGenerator timestampGenerator, SpeculativeExecutionPolicy speculativeExecutionPolicy, EndPointFactory endPointFactory) {
        this.loadBalancingPolicy = loadBalancingPolicy;
        this.reconnectionPolicy = reconnectionPolicy;
        this.retryPolicy = retryPolicy;
        this.addressTranslator = addressTranslator;
        this.timestampGenerator = timestampGenerator;
        this.speculativeExecutionPolicy = speculativeExecutionPolicy;
        this.endPointFactory = endPointFactory;
    }

    public static LoadBalancingPolicy defaultLoadBalancingPolicy() {
        return new TokenAwarePolicy(DCAwareRoundRobinPolicy.builder().build());
    }

    public static ReconnectionPolicy defaultReconnectionPolicy() {
        return DEFAULT_RECONNECTION_POLICY;
    }

    public static RetryPolicy defaultRetryPolicy() {
        return DEFAULT_RETRY_POLICY;
    }

    public static AddressTranslator defaultAddressTranslator() {
        return DEFAULT_ADDRESS_TRANSLATOR;
    }

    public static TimestampGenerator defaultTimestampGenerator() {
        return new AtomicMonotonicTimestampGenerator();
    }

    public static SpeculativeExecutionPolicy defaultSpeculativeExecutionPolicy() {
        return DEFAULT_SPECULATIVE_EXECUTION_POLICY;
    }

    public static EndPointFactory defaultEndPointFactory() {
        return new DefaultEndPointFactory();
    }

    public LoadBalancingPolicy getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public ReconnectionPolicy getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public AddressTranslator getAddressTranslator() {
        return this.addressTranslator;
    }

    public TimestampGenerator getTimestampGenerator() {
        return this.timestampGenerator;
    }

    public SpeculativeExecutionPolicy getSpeculativeExecutionPolicy() {
        return this.speculativeExecutionPolicy;
    }

    public EndPointFactory getEndPointFactory() {
        return this.endPointFactory;
    }

    public static class Builder {
        private LoadBalancingPolicy loadBalancingPolicy;
        private ReconnectionPolicy reconnectionPolicy;
        private RetryPolicy retryPolicy;
        private AddressTranslator addressTranslator;
        private TimestampGenerator timestampGenerator;
        private SpeculativeExecutionPolicy speculativeExecutionPolicy;
        private EndPointFactory endPointFactory;

        public Builder withLoadBalancingPolicy(LoadBalancingPolicy loadBalancingPolicy) {
            this.loadBalancingPolicy = loadBalancingPolicy;
            return this;
        }

        public Builder withReconnectionPolicy(ReconnectionPolicy reconnectionPolicy) {
            this.reconnectionPolicy = reconnectionPolicy;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder withAddressTranslator(AddressTranslator addressTranslator) {
            this.addressTranslator = addressTranslator;
            return this;
        }

        public Builder withTimestampGenerator(TimestampGenerator timestampGenerator) {
            this.timestampGenerator = timestampGenerator;
            return this;
        }

        public Builder withSpeculativeExecutionPolicy(SpeculativeExecutionPolicy speculativeExecutionPolicy) {
            this.speculativeExecutionPolicy = speculativeExecutionPolicy;
            return this;
        }

        public Builder withEndPointFactory(EndPointFactory endPointFactory) {
            this.endPointFactory = endPointFactory;
            return this;
        }

        public Policies build() {
            return new Policies(this.loadBalancingPolicy == null ? Policies.defaultLoadBalancingPolicy() : this.loadBalancingPolicy, this.reconnectionPolicy == null ? Policies.defaultReconnectionPolicy() : this.reconnectionPolicy, this.retryPolicy == null ? Policies.defaultRetryPolicy() : this.retryPolicy, this.addressTranslator == null ? Policies.defaultAddressTranslator() : this.addressTranslator, this.timestampGenerator == null ? Policies.defaultTimestampGenerator() : this.timestampGenerator, this.speculativeExecutionPolicy == null ? Policies.defaultSpeculativeExecutionPolicy() : this.speculativeExecutionPolicy, this.endPointFactory == null ? Policies.defaultEndPointFactory() : this.endPointFactory);
        }
    }
}

