/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.policies;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.Clock;

class RollingCount {
    private static final long INTERVAL_SIZE = TimeUnit.SECONDS.toNanos(5L);
    private final AtomicLongArray previousIntervals = new AtomicLongArray(12);
    private final AtomicLong currentInterval = new AtomicLong();
    private final AtomicReference<State> state;
    private final Clock clock;

    RollingCount(Clock clock) {
        this.state = new AtomicReference<State>(new State(clock.nanoTime()));
        this.clock = clock;
    }

    void increment() {
        this.add(1L);
    }

    void add(long amount) {
        this.tickIfNecessary();
        this.currentInterval.addAndGet(amount);
    }

    long get() {
        this.tickIfNecessary();
        return this.state.get().totalCount;
    }

    private void tickIfNecessary() {
        State oldState = this.state.get();
        long newTick = this.clock.nanoTime();
        long age = newTick - oldState.lastTick;
        if (age >= INTERVAL_SIZE) {
            long newTotal;
            long currentCount = this.currentInterval.get();
            long newIntervalStartTick = newTick - age % INTERVAL_SIZE;
            long elapsedIntervals = Math.min(age / INTERVAL_SIZE, 12L);
            int newOffset = (int)(((long)oldState.offset + elapsedIntervals) % 12L);
            if (elapsedIntervals == 12L) {
                newTotal = 0L;
            } else {
                newTotal = oldState.totalCount + currentCount;
                int i = 1;
                while ((long)i <= elapsedIntervals) {
                    newTotal -= this.previousIntervals.get((newOffset + 12 - i) % 12);
                    ++i;
                }
            }
            State newState = new State(newIntervalStartTick, newOffset, newTotal);
            if (this.state.compareAndSet(oldState, newState)) {
                this.currentInterval.addAndGet(-currentCount);
                this.previousIntervals.set(oldState.offset, elapsedIntervals < 12L ? currentCount : 0L);
                int i = 1;
                while ((long)i < elapsedIntervals) {
                    this.previousIntervals.set((newOffset + 12 - i) % 12, 0L);
                    ++i;
                }
            }
        }
    }

    static class State {
        final long lastTick;
        final int offset;
        final long totalCount;

        State(long lastTick) {
            this(lastTick, 0, 0L);
        }

        State(long lastTick, int offset, long totalCount) {
            this.lastTick = lastTick;
            this.offset = offset;
            this.totalCount = totalCount;
        }
    }
}

