/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.policies;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.scylladb.cdc.driver3.common.collect.AbstractIterator;
import shaded.com.scylladb.cdc.driver3.driver.core.Cluster;
import shaded.com.scylladb.cdc.driver3.driver.core.Configuration;
import shaded.com.scylladb.cdc.driver3.driver.core.ConsistencyLevel;
import shaded.com.scylladb.cdc.driver3.driver.core.Host;
import shaded.com.scylladb.cdc.driver3.driver.core.HostDistance;
import shaded.com.scylladb.cdc.driver3.driver.core.Statement;
import shaded.com.scylladb.cdc.driver3.driver.core.policies.LoadBalancingPolicy;

public class RoundRobinPolicy
implements LoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(RoundRobinPolicy.class);
    private final CopyOnWriteArrayList<Host> liveHosts = new CopyOnWriteArrayList();
    private final AtomicInteger index = new AtomicInteger();
    private volatile Configuration configuration;
    private volatile boolean hasLoggedLocalCLUse;

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.liveHosts.addAll(hosts);
        this.configuration = cluster.getConfiguration();
        this.index.set(new Random().nextInt(Math.max(hosts.size(), 1)));
    }

    @Override
    public HostDistance distance(Host host) {
        return HostDistance.LOCAL;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        if (!this.hasLoggedLocalCLUse) {
            ConsistencyLevel cl;
            ConsistencyLevel consistencyLevel = cl = statement.getConsistencyLevel() == null ? this.configuration.getQueryOptions().getConsistencyLevel() : statement.getConsistencyLevel();
            if (cl.isDCLocal()) {
                this.hasLoggedLocalCLUse = true;
                logger.warn("Detected request at Consistency Level {} but the non-DC aware RoundRobinPolicy is in use. It is strongly advised to use DCAwareRoundRobinPolicy if you have multiple DCs/use DC-aware consistency levels (note: this message will only be logged once)", (Object)cl);
            }
        }
        final List hosts = (List)this.liveHosts.clone();
        final int startIdx = this.index.getAndIncrement();
        if (startIdx > 2147473647) {
            this.index.set(0);
        }
        return new AbstractIterator<Host>(){
            private int idx;
            private int remaining;
            {
                this.idx = startIdx;
                this.remaining = hosts.size();
            }

            @Override
            protected Host computeNext() {
                int c;
                if (this.remaining <= 0) {
                    return (Host)this.endOfData();
                }
                --this.remaining;
                if ((c = this.idx++ % hosts.size()) < 0) {
                    c += hosts.size();
                }
                return (Host)hosts.get(c);
            }
        };
    }

    @Override
    public void onUp(Host host) {
        this.liveHosts.addIfAbsent(host);
    }

    @Override
    public void onDown(Host host) {
        this.liveHosts.remove(host);
    }

    @Override
    public void onAdd(Host host) {
        this.onUp(host);
    }

    @Override
    public void onRemove(Host host) {
        this.onDown(host);
    }

    @Override
    public void close() {
    }
}

