/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Metadata;
import shaded.com.scylladb.cdc.driver3.driver.core.TableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.BindMarker;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.BuiltStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.Clause;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.Using;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.Utils;

public class Delete
extends BuiltStatement {
    private final String table;
    private final List<Selector> columns;
    private final Where where;
    private final Options usings;
    private final Conditions conditions;
    private boolean ifExists;

    Delete(String keyspace, String table, List<Selector> columns) {
        this(keyspace, table, null, null, columns);
    }

    Delete(TableMetadata table, List<Selector> columns) {
        this(Metadata.quoteIfNecessary(table.getKeyspace().getName()), Metadata.quoteIfNecessary(table.getName()), Arrays.asList(new Object[table.getPartitionKey().size()]), table.getPartitionKey(), columns);
    }

    Delete(String keyspace, String table, List<Object> routingKeyValues, List<ColumnMetadata> partitionKey, List<Selector> columns) {
        super(keyspace, partitionKey, routingKeyValues);
        this.table = table;
        this.columns = columns;
        this.where = new Where(this);
        this.usings = new Options(this);
        this.conditions = new Conditions(this);
        if (!this.areIdempotent(columns)) {
            this.setNonIdempotentOps();
        }
    }

    @Override
    StringBuilder buildQueryString(List<Object> variables, CodecRegistry codecRegistry) {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE");
        if (!this.columns.isEmpty()) {
            Utils.joinAndAppend(builder.append(" "), codecRegistry, ",", this.columns, variables);
        }
        builder.append(" FROM ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.usings.usings, variables);
        }
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.where.clauses, variables);
        }
        if (this.ifExists) {
            builder.append(" IF EXISTS ");
        }
        if (!this.conditions.conditions.isEmpty()) {
            builder.append(" IF ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.conditions.conditions, variables);
        }
        return builder;
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Conditions onlyIf(Clause condition) {
        return this.conditions.and(condition);
    }

    public Conditions onlyIf() {
        return this.conditions;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public Options using() {
        return this.usings;
    }

    public Delete ifExists() {
        this.ifExists = true;
        this.setNonIdempotentOps();
        return this;
    }

    private boolean areIdempotent(List<Selector> selectors) {
        for (Selector sel : selectors) {
            if (!(sel instanceof ListElementSelector)) continue;
            return false;
        }
        return true;
    }

    public static class Conditions
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Clause> conditions = new ArrayList<Clause>();

        Conditions(Delete statement) {
            super(statement);
        }

        public Conditions and(Clause condition) {
            ((Delete)this.statement).setNonIdempotentOps();
            this.conditions.add(condition);
            this.checkForBindMarkers(condition);
            return this;
        }

        public Where where(Clause clause) {
            return ((Delete)this.statement).where(clause);
        }

        public Options using(Using using) {
            return ((Delete)this.statement).using(using);
        }
    }

    private static class MapElementSelector
    extends CollectionElementSelector {
        MapElementSelector(String columnName, Object key) {
            super(columnName, key);
        }
    }

    private static class SetElementSelector
    extends CollectionElementSelector {
        SetElementSelector(String columnName, Object key) {
            super(columnName, key);
        }
    }

    private static class ListElementSelector
    extends CollectionElementSelector {
        ListElementSelector(String columnName, Object key) {
            super(columnName, key);
        }
    }

    private static class CollectionElementSelector
    extends Selector {
        protected final Object key;

        CollectionElementSelector(String columnName, Object key) {
            super(columnName);
            this.key = key;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> values, CodecRegistry codecRegistry) {
            super.appendTo(sb, values, codecRegistry);
            sb.append('[');
            Utils.appendValue(this.key, codecRegistry, sb, values);
            sb.append(']');
        }

        @Override
        boolean containsBindMarker() {
            return Utils.containsBindMarker(this.key);
        }
    }

    private static class Selector
    extends Utils.Appendeable {
        private final String columnName;

        Selector(String columnName) {
            this.columnName = columnName;
        }

        @Override
        void appendTo(StringBuilder sb, List<Object> values, CodecRegistry codecRegistry) {
            Utils.appendName(this.columnName, sb);
        }

        @Override
        boolean containsBindMarker() {
            return false;
        }

        public String toString() {
            return this.columnName;
        }
    }

    public static class Selection
    extends Builder {
        public Builder all() {
            if (!this.columns.isEmpty()) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columns));
            }
            return this;
        }

        public Selection column(String columnName) {
            this.columns.add(new Selector(columnName));
            return this;
        }

        public Selection listElt(String columnName, int idx) {
            this.columns.add(new ListElementSelector(columnName, idx));
            return this;
        }

        public Selection listElt(String columnName, BindMarker idx) {
            this.columns.add(new ListElementSelector(columnName, idx));
            return this;
        }

        public Selection setElt(String columnName, Object element) {
            this.columns.add(new SetElementSelector(columnName, element));
            return this;
        }

        public Selection setElt(String columnName, BindMarker element) {
            this.columns.add(new SetElementSelector(columnName, element));
            return this;
        }

        public Selection mapElt(String columnName, Object key) {
            this.columns.add(new MapElementSelector(columnName, key));
            return this;
        }
    }

    public static class Builder {
        List<Selector> columns = new ArrayList<Selector>();

        Builder() {
        }

        Builder(String ... columnNames) {
            for (String columnName : columnNames) {
                this.columns.add(new Selector(columnName));
            }
        }

        public Delete from(String table) {
            return this.from(null, table);
        }

        public Delete from(String keyspace, String table) {
            return new Delete(keyspace, table, this.columns);
        }

        public Delete from(TableMetadata table) {
            return new Delete(table, this.columns);
        }
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Delete statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.checkForBindMarkers(using);
            return this;
        }

        public Where where(Clause clause) {
            return ((Delete)this.statement).where(clause);
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Delete> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Delete statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Delete)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            if (!this.hasNonIdempotentOps() && !Utils.isIdempotent(clause)) {
                ((Delete)this.statement).setNonIdempotentOps();
            }
            this.checkForBindMarkers(clause);
            return this;
        }

        public Options using(Using using) {
            return ((Delete)this.statement).using(using);
        }

        public Delete ifExists() {
            return ((Delete)this.statement).ifExists();
        }

        public Conditions onlyIf(Clause condition) {
            return ((Delete)this.statement).onlyIf(condition);
        }
    }
}

