/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.querybuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.driver.core.AbstractTableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.CodecRegistry;
import shaded.com.scylladb.cdc.driver3.driver.core.ColumnMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.DataType;
import shaded.com.scylladb.cdc.driver3.driver.core.MaterializedViewMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.Metadata;
import shaded.com.scylladb.cdc.driver3.driver.core.TableMetadata;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.BindMarker;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.BuiltStatement;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.Clause;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.Ordering;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.QueryBuilder;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.Using;
import shaded.com.scylladb.cdc.driver3.driver.core.querybuilder.Utils;

public class Select
extends BuiltStatement {
    private static final List<Object> COUNT_ALL = Collections.singletonList(new Utils.FCall("count", new Utils.RawString("*")));
    private final String table;
    private final boolean isDistinct;
    private final boolean isJson;
    private final List<Object> columnNames;
    private final Where where;
    private final Options usings;
    private List<Ordering> orderings;
    private List<Object> groupByColumnNames;
    private Object limit;
    private Object perPartitionLimit;
    private boolean allowFiltering;
    private boolean bypassCache;

    Select(String keyspace, String table, List<Object> columnNames, boolean isDistinct, boolean isJson) {
        this(keyspace, table, null, null, columnNames, isDistinct, isJson);
    }

    Select(AbstractTableMetadata table, List<Object> columnNames, boolean isDistinct, boolean isJson) {
        this(Metadata.quoteIfNecessary(table.getKeyspace().getName()), Metadata.quoteIfNecessary(table.getName()), Arrays.asList(new Object[table.getPartitionKey().size()]), table.getPartitionKey(), columnNames, isDistinct, isJson);
    }

    Select(String keyspace, String table, List<Object> routingKeyValues, List<ColumnMetadata> partitionKey, List<Object> columnNames, boolean isDistinct, boolean isJson) {
        super(keyspace, partitionKey, routingKeyValues);
        this.table = table;
        this.columnNames = columnNames;
        this.isDistinct = isDistinct;
        this.isJson = isJson;
        this.where = new Where(this);
        this.usings = new Options(this);
    }

    @Override
    StringBuilder buildQueryString(List<Object> variables, CodecRegistry codecRegistry) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (this.isJson) {
            builder.append("JSON ");
        }
        if (this.isDistinct) {
            builder.append("DISTINCT ");
        }
        if (this.columnNames == null) {
            builder.append('*');
        } else {
            Utils.joinAndAppendNames(builder, codecRegistry, this.columnNames);
        }
        builder.append(" FROM ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append('.');
        }
        Utils.appendName(this.table, builder);
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.where.clauses, variables);
        }
        if (this.groupByColumnNames != null) {
            builder.append(" GROUP BY ");
            Utils.joinAndAppendNames(builder, codecRegistry, this.groupByColumnNames);
        }
        if (this.orderings != null) {
            builder.append(" ORDER BY ");
            Utils.joinAndAppend(builder, codecRegistry, ",", this.orderings, variables);
        }
        if (this.perPartitionLimit != null) {
            builder.append(" PER PARTITION LIMIT ").append(this.perPartitionLimit);
        }
        if (this.limit != null) {
            builder.append(" LIMIT ").append(this.limit);
        }
        if (this.allowFiltering) {
            builder.append(" ALLOW FILTERING");
        }
        if (this.bypassCache) {
            builder.append(" BYPASS CACHE");
        }
        if (!this.usings.usings.isEmpty()) {
            builder.append(" USING ");
            Utils.joinAndAppend(builder, codecRegistry, " AND ", this.usings.usings, variables);
        }
        return builder;
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Options using(Using using) {
        return this.usings.and(using);
    }

    public Select orderBy(Ordering ... orderings) {
        if (this.orderings != null) {
            throw new IllegalStateException("An ORDER BY clause has already been provided");
        }
        if (orderings.length == 0) {
            throw new IllegalArgumentException("Invalid ORDER BY argument, the orderings must not be empty.");
        }
        this.orderings = Arrays.asList(orderings);
        for (Ordering ordering : orderings) {
            this.checkForBindMarkers(ordering);
        }
        return this;
    }

    public Select groupBy(Object ... columns) {
        if (this.groupByColumnNames != null) {
            throw new IllegalStateException("A GROUP BY clause has already been provided");
        }
        this.groupByColumnNames = Arrays.asList(columns);
        return this;
    }

    public Select limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid LIMIT value, must be strictly positive");
        }
        if (this.limit != null) {
            throw new IllegalStateException("A LIMIT value has already been provided");
        }
        this.limit = limit;
        this.setDirty();
        return this;
    }

    public Select limit(BindMarker marker) {
        if (this.limit != null) {
            throw new IllegalStateException("A LIMIT value has already been provided");
        }
        this.limit = marker;
        this.checkForBindMarkers(marker);
        return this;
    }

    public Select perPartitionLimit(int perPartitionLimit) {
        if (perPartitionLimit <= 0) {
            throw new IllegalArgumentException("Invalid PER PARTITION LIMIT value, must be strictly positive");
        }
        if (this.perPartitionLimit != null) {
            throw new IllegalStateException("A PER PARTITION LIMIT value has already been provided");
        }
        if (this.isDistinct) {
            throw new IllegalStateException("PER PARTITION LIMIT is not allowed with SELECT DISTINCT queries");
        }
        this.perPartitionLimit = perPartitionLimit;
        this.setDirty();
        return this;
    }

    public Select perPartitionLimit(BindMarker marker) {
        if (this.perPartitionLimit != null) {
            throw new IllegalStateException("A PER PARTITION LIMIT value has already been provided");
        }
        if (this.isDistinct) {
            throw new IllegalStateException("PER PARTITION LIMIT is not allowed with SELECT DISTINCT queries");
        }
        this.perPartitionLimit = marker;
        this.checkForBindMarkers(marker);
        return this;
    }

    public Select allowFiltering() {
        this.allowFiltering = true;
        return this;
    }

    public Select bypassCache() {
        this.bypassCache = true;
        return this;
    }

    public static class SelectionOrAlias
    extends Selection {
        private Object previousSelection;

        public Selection as(String alias) {
            assert (this.previousSelection != null);
            Utils.Alias a = new Utils.Alias(this.previousSelection, alias);
            this.previousSelection = null;
            return this.addName(a);
        }

        private Selection addName(Object name) {
            if (this.columnNames == null) {
                this.columnNames = new ArrayList();
            }
            this.columnNames.add(name);
            return this;
        }

        private SelectionOrAlias queueName(Object name) {
            if (this.previousSelection != null) {
                this.addName(this.previousSelection);
            }
            this.previousSelection = name;
            return this;
        }

        @Override
        public Builder all() {
            if (this.columnNames != null) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columnNames));
            }
            if (this.previousSelection != null) {
                throw new IllegalStateException(String.format("Some columns ([%s]) have already been selected.", this.previousSelection));
            }
            return this;
        }

        @Override
        public Builder countAll() {
            if (this.columnNames != null) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columnNames));
            }
            if (this.previousSelection != null) {
                throw new IllegalStateException(String.format("Some columns ([%s]) have already been selected.", this.previousSelection));
            }
            this.columnNames = COUNT_ALL;
            return this;
        }

        @Override
        public SelectionOrAlias column(String name) {
            return this.queueName(name);
        }

        @Override
        public SelectionOrAlias writeTime(String name) {
            return this.queueName(new Utils.FCall("writetime", new Utils.CName(name)));
        }

        @Override
        public SelectionOrAlias ttl(String name) {
            return this.queueName(new Utils.FCall("ttl", new Utils.CName(name)));
        }

        @Override
        public SelectionOrAlias fcall(String name, Object ... parameters) {
            return this.queueName(new Utils.FCall(name, parameters));
        }

        @Override
        public SelectionOrAlias cast(Object column, DataType targetType) {
            return this.queueName(QueryBuilder.cast(column, targetType));
        }

        @Override
        public SelectionOrAlias raw(String rawString) {
            return this.queueName(QueryBuilder.raw(rawString));
        }

        @Override
        public SelectionOrAlias path(String ... segments) {
            return this.queueName(QueryBuilder.path(segments));
        }

        @Override
        public SelectionOrAlias toJson(String name) {
            return this.queueName(QueryBuilder.toJson(name));
        }

        @Override
        public SelectionOrAlias count(Object column) {
            return this.queueName(QueryBuilder.count(column));
        }

        @Override
        public SelectionOrAlias max(Object column) {
            return this.queueName(QueryBuilder.max(column));
        }

        @Override
        public SelectionOrAlias min(Object column) {
            return this.queueName(QueryBuilder.min(column));
        }

        @Override
        public SelectionOrAlias sum(Object column) {
            return this.queueName(QueryBuilder.sum(column));
        }

        @Override
        public SelectionOrAlias avg(Object column) {
            return this.queueName(QueryBuilder.avg(column));
        }

        @Override
        public Select from(String keyspace, String table) {
            if (this.previousSelection != null) {
                this.addName(this.previousSelection);
            }
            this.previousSelection = null;
            return super.from(keyspace, table);
        }

        @Override
        public Select from(TableMetadata table) {
            if (this.previousSelection != null) {
                this.addName(this.previousSelection);
            }
            this.previousSelection = null;
            return super.from(table);
        }

        @Override
        public Select from(MaterializedViewMetadata view) {
            if (this.previousSelection != null) {
                this.addName(this.previousSelection);
            }
            this.previousSelection = null;
            return super.from(view);
        }
    }

    public static abstract class Selection
    extends Builder {
        @Override
        public Selection distinct() {
            this.isDistinct = true;
            return this;
        }

        @Override
        public Selection json() {
            this.isJson = true;
            return this;
        }

        public abstract Builder all();

        public abstract Builder countAll();

        public abstract SelectionOrAlias column(String var1);

        public abstract SelectionOrAlias writeTime(String var1);

        public abstract SelectionOrAlias ttl(String var1);

        public abstract SelectionOrAlias fcall(String var1, Object ... var2);

        public SelectionOrAlias cast(Object column, DataType targetType) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias raw(String rawString) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias path(String ... segments) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias toJson(String column) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias count(Object column) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias max(Object column) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias min(Object column) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias sum(Object column) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }

        public SelectionOrAlias avg(Object column) {
            throw new UnsupportedOperationException("Not implemented. This should only happen if you've written your own implementation of Selection");
        }
    }

    public static class Builder {
        List<Object> columnNames;
        boolean isDistinct;
        boolean isJson;

        Builder() {
        }

        Builder(List<Object> columnNames) {
            this.columnNames = columnNames;
        }

        public Builder distinct() {
            this.isDistinct = true;
            return this;
        }

        public Builder json() {
            this.isJson = true;
            return this;
        }

        public Select from(String table) {
            return this.from(null, table);
        }

        public Select from(String keyspace, String table) {
            return new Select(keyspace, table, this.columnNames, this.isDistinct, this.isJson);
        }

        public Select from(TableMetadata table) {
            return new Select(table, this.columnNames, this.isDistinct, this.isJson);
        }

        public Select from(MaterializedViewMetadata view) {
            return new Select(view, this.columnNames, this.isDistinct, this.isJson);
        }
    }

    public static class Options
    extends BuiltStatement.ForwardingStatement<Select> {
        private final List<Using> usings = new ArrayList<Using>();

        Options(Select statement) {
            super(statement);
        }

        public Options and(Using using) {
            this.usings.add(using);
            this.checkForBindMarkers(using);
            return this;
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Select> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Select statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Select)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            this.checkForBindMarkers(clause);
            return this;
        }

        public Options using(Using using) {
            return ((Select)this.statement).using(using);
        }

        public Select orderBy(Ordering ... orderings) {
            return ((Select)this.statement).orderBy(orderings);
        }

        public Select groupBy(Object ... columns) {
            return ((Select)this.statement).groupBy(columns);
        }

        public Select limit(int limit) {
            return ((Select)this.statement).limit(limit);
        }

        public Select limit(BindMarker limit) {
            return ((Select)this.statement).limit(limit);
        }

        public Select perPartitionLimit(int perPartitionLimit) {
            return ((Select)this.statement).perPartitionLimit(perPartitionLimit);
        }

        public Select perPartitionLimit(BindMarker limit) {
            return ((Select)this.statement).perPartitionLimit(limit);
        }

        public Select allowFiltering() {
            return ((Select)this.statement).allowFiltering();
        }

        public Select bypassCache() {
            return ((Select)this.statement).bypassCache();
        }
    }
}

