/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.driver.core.schemabuilder;

import shaded.com.scylladb.cdc.driver3.driver.core.schemabuilder.SchemaStatement;

public class DropKeyspace
extends SchemaStatement {
    private final String keyspaceName;
    private boolean ifExists;

    public DropKeyspace(String keyspaceName) {
        this.keyspaceName = keyspaceName;
        this.ifExists = false;
        DropKeyspace.validateNotEmpty(keyspaceName, "Keyspace name");
        DropKeyspace.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
    }

    public DropKeyspace ifExists() {
        this.ifExists = true;
        return this;
    }

    @Override
    public String buildInternal() {
        StringBuilder dropStatement = new StringBuilder("DROP KEYSPACE ");
        if (this.ifExists) {
            dropStatement.append("IF EXISTS ");
        }
        dropStatement.append(this.keyspaceName);
        return dropStatement.toString();
    }
}

