/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.handler.address;

import java.net.SocketAddress;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandler;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandlerContext;
import shaded.com.scylladb.cdc.driver3.channel.ChannelOutboundHandlerAdapter;
import shaded.com.scylladb.cdc.driver3.channel.ChannelPromise;
import shaded.com.scylladb.cdc.driver3.resolver.AddressResolver;
import shaded.com.scylladb.cdc.driver3.resolver.AddressResolverGroup;
import shaded.com.scylladb.cdc.driver3.util.concurrent.Future;
import shaded.com.scylladb.cdc.driver3.util.concurrent.FutureListener;
import shaded.com.scylladb.cdc.driver3.util.concurrent.GenericFutureListener;
import shaded.com.scylladb.cdc.driver3.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

