/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.handler.codec.compression;

import java.nio.ByteBuffer;
import shaded.com.scylladb.cdc.driver3.buffer.ByteBuf;
import shaded.com.scylladb.cdc.driver3.handler.codec.compression.ByteBufChecksum;
import shaded.com.scylladb.cdc.driver3.handler.codec.compression.DecompressionException;

final class CompressionUtil {
    private CompressionUtil() {
    }

    static void checkChecksum(ByteBufChecksum checksum, ByteBuf uncompressed, int currentChecksum) {
        checksum.reset();
        checksum.update(uncompressed, uncompressed.readerIndex(), uncompressed.readableBytes());
        int checksumResult = (int)checksum.getValue();
        if (checksumResult != currentChecksum) {
            throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", checksumResult, currentChecksum));
        }
    }

    static ByteBuffer safeReadableNioBuffer(ByteBuf buffer) {
        return CompressionUtil.safeNioBuffer(buffer, buffer.readerIndex(), buffer.readableBytes());
    }

    static ByteBuffer safeNioBuffer(ByteBuf buffer, int index, int length) {
        return buffer.nioBufferCount() == 1 ? buffer.internalNioBuffer(index, length) : buffer.nioBuffer(index, length);
    }
}

