/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.handler.codec.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.buffer.ByteBuf;
import shaded.com.scylladb.cdc.driver3.buffer.ByteBufUtil;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandler;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandlerContext;
import shaded.com.scylladb.cdc.driver3.handler.codec.MessageToMessageEncoder;
import shaded.com.scylladb.cdc.driver3.handler.codec.string.LineSeparator;
import shaded.com.scylladb.cdc.driver3.util.CharsetUtil;
import shaded.com.scylladb.cdc.driver3.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class LineEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;
    private final byte[] lineSeparator;

    public LineEncoder() {
        this(LineSeparator.DEFAULT, CharsetUtil.UTF_8);
    }

    public LineEncoder(LineSeparator lineSeparator) {
        this(lineSeparator, CharsetUtil.UTF_8);
    }

    public LineEncoder(Charset charset) {
        this(LineSeparator.DEFAULT, charset);
    }

    public LineEncoder(LineSeparator lineSeparator, Charset charset) {
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
        this.lineSeparator = ObjectUtil.checkNotNull(lineSeparator, "lineSeparator").value().getBytes(charset);
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        ByteBuf buffer = ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset, this.lineSeparator.length);
        buffer.writeBytes(this.lineSeparator);
        out.add(buffer);
    }
}

