/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.scylladb.cdc.driver3.handler.codec.string;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;
import shaded.com.scylladb.cdc.driver3.buffer.ByteBufUtil;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandler;
import shaded.com.scylladb.cdc.driver3.channel.ChannelHandlerContext;
import shaded.com.scylladb.cdc.driver3.handler.codec.MessageToMessageEncoder;
import shaded.com.scylladb.cdc.driver3.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public class StringEncoder
extends MessageToMessageEncoder<CharSequence> {
    private final Charset charset;

    public StringEncoder() {
        this(Charset.defaultCharset());
    }

    public StringEncoder(Charset charset) {
        this.charset = ObjectUtil.checkNotNull(charset, "charset");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, CharSequence msg, List<Object> out) throws Exception {
        if (msg.length() == 0) {
            return;
        }
        out.add(ByteBufUtil.encodeString(ctx.alloc(), CharBuffer.wrap(msg), this.charset));
    }
}

